/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.Executors;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.connector.BpelServerConnector;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementMBean;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.jbi.BindingContextImpl;
import org.apache.ode.jbi.EndpointReferenceContextImpl;
import org.apache.ode.jbi.MessageExchangeContextImpl;
import org.apache.ode.jbi.Messages;
import org.apache.ode.jbi.OdeConfigProperties;
import org.apache.ode.jbi.OdeConsumerAsync;
import org.apache.ode.jbi.OdeConsumerSync;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.jbi.OdeSUManager;
import org.apache.ode.jbi.Receiver;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.fs.TempFileManager;

public class OdeLifeCycle
implements ComponentLifeCycle {
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final Log __log = LogFactory.getLog(OdeLifeCycle.class);
    private OdeSUManager _suManager = null;
    private boolean _initSuccess = false;
    private OdeContext _ode;
    private Receiver _receiver;
    private boolean _started;
    private BpelServerConnector _connector;
    private Database _db;
    private ObjectName _mbeanName;
    private OdeConfigProperties _config;

    public OdeLifeCycle() {
    }

    public OdeLifeCycle(OdeConfigProperties config) {
        this._config = config;
    }

    ServiceUnitManager getSUManager() {
        return this._suManager;
    }

    OdeContext getOdeContext() {
        return this._ode;
    }

    public ObjectName getExtensionMBeanName() {
        return this._mbeanName;
    }

    public void init(ComponentContext context) throws JBIException {
        try {
            this._ode = OdeContext.getInstance();
            this._ode.setContext(context);
            this._ode._consumer = Boolean.getBoolean("org.apache.ode.jbi.sendSynch") ? new OdeConsumerSync(this._ode) : new OdeConsumerAsync(this._ode);
            if (this._ode.getContext().getWorkspaceRoot() != null) {
                TempFileManager.setWorkingDirectory((File)new File(this._ode.getContext().getWorkspaceRoot()));
            }
            if (this._config == null) {
                __log.debug((Object)"Loading properties.");
                this.initProperties();
            } else {
                __log.debug((Object)"Applying properties.");
                this._ode._config = this._config;
            }
            __log.debug((Object)"Initializing message mappers.");
            this.initMappers();
            __log.debug((Object)"Creating data source.");
            this.initDataSource();
            __log.debug((Object)"Starting Dao.");
            this.initDao();
            __log.debug((Object)"Starting BPEL server.");
            this.initBpelServer();
            this.registerEventListeners();
            this.registerMexInterceptors();
            this.registerMBean();
            __log.debug((Object)"Starting JCA connector.");
            this.initConnector();
            __log.debug((Object)"Register ProcessManagement APIs");
            this._ode.activatePMAPIs();
            this._suManager = new OdeSUManager(this._ode);
            this._initSuccess = true;
            __log.info((Object)__msgs.msgOdeInitialized());
        }
        catch (Throwable t) {
            __log.fatal((Object)"", t);
            throw new JBIException("Fatal error", t);
        }
    }

    private void initMappers() throws JBIException {
        String[] mappers;
        for (String className : mappers = this._ode._config.getMessageMappers()) {
            Class<?> mapperClass;
            try {
                mapperClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                String errmsg = __msgs.msgOdeInitMapperClassNotFound(className);
                __log.error((Object)errmsg);
                throw new JBIException(errmsg, (Throwable)e);
            }
            catch (Throwable t) {
                String errmsg = __msgs.msgOdeInitMapperClassLoadFailed(className);
                __log.error((Object)errmsg);
                throw new JBIException(errmsg, t);
            }
            try {
                this._ode.registerMapper((Mapper)mapperClass.newInstance());
            }
            catch (Throwable t) {
                String errmsg = __msgs.msgOdeInitMapperInstantiationFailed(className);
                __log.error((Object)errmsg);
                throw new JBIException(errmsg, t);
            }
        }
    }

    private void initDataSource() throws JBIException {
        this._db = new Database((org.apache.ode.il.config.OdeConfigProperties)this._ode._config);
        this._db.setTransactionManager(this._ode.getTransactionManager());
        this._db.setWorkRoot(new File(this._ode.getContext().getInstallRoot()));
        try {
            this._db.start();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbConfigError();
            __log.error((Object)errmsg, (Throwable)ex);
            throw new JBIException(errmsg, (Throwable)ex);
        }
        this._ode._dataSource = this._db.getDataSource();
    }

    private void initProperties() throws JBIException {
        OdeConfigProperties config = new OdeConfigProperties(new File(this._ode.getContext().getInstallRoot(), "ode-jbi.properties"));
        try {
            config.load();
        }
        catch (FileNotFoundException fnf) {
            __log.warn((Object)__msgs.msgOdeInstallErrorCfgNotFound(config.getFile()));
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeInstallErrorCfgReadError(config.getFile());
            throw new JBIException(errmsg, (Throwable)ex);
        }
        this._ode._config = config;
    }

    private void initBpelServer() throws JBIException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"ODE initializing");
        }
        this._ode._server = new BpelServerImpl();
        this._ode._eprContext = new EndpointReferenceContextImpl(this._ode);
        this._ode._mexContext = new MessageExchangeContextImpl(this._ode);
        this._ode._executorService = this._ode._config.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(this._ode._config.getThreadPoolMaxSize());
        this._ode._scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._ode._dataSource), this._ode._config.getProperties());
        this._ode._scheduler.setJobProcessor((Scheduler.JobProcessor)this._ode._server);
        this._ode._scheduler.setExecutorService(this._ode._executorService);
        this._ode._scheduler.setTransactionManager((TransactionManager)this._ode.getContext().getTransactionManager());
        this._ode._store = new ProcessStoreImpl((EndpointReferenceContext)this._ode._eprContext, this._ode._dataSource, this._ode._config.getDAOConnectionFactory(), (org.apache.ode.il.config.OdeConfigProperties)this._ode._config, false);
        this.registerExternalVariableModules();
        this._ode._store.loadAll();
        this._ode._server.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl((Scheduler)this._ode._scheduler, this._ode._config.getInMemMexTtl()));
        this._ode._server.setDaoConnectionFactory(this._ode._daocf);
        this._ode._server.setEndpointReferenceContext((EndpointReferenceContext)this._ode._eprContext);
        this._ode._server.setMessageExchangeContext((MessageExchangeContext)this._ode._mexContext);
        this._ode._server.setBindingContext((BindingContext)new BindingContextImpl(this._ode));
        this._ode._server.setScheduler((Scheduler)this._ode._scheduler);
        this._ode._server.setConfigProperties(this._ode._config.getProperties());
        this._ode._server.init();
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcext = new JdbcExternalVariableModule();
        jdbcext.registerDataSource("ode", this._db.getDataSource());
        this._ode._server.registerExternalVariableEngine((ExternalVariableModule)jdbcext);
    }

    private void initDao() throws JBIException {
        BpelDAOConnectionFactoryJDBC cf;
        try {
            cf = this._db.createDaoCF();
        }
        catch (DatabaseConfigException e) {
            String errmsg = __msgs.msgDAOInstantiationFailed(this._ode._config.getDAOConnectionFactory());
            throw new JBIException(errmsg, (Throwable)e);
        }
        this._ode._daocf = cf;
    }

    private void initConnector() throws JBIException {
        int port = this._ode._config.getConnectorPort();
        if (port == 0) {
            __log.info((Object)"Skipping connector initialization.");
        } else {
            this._connector = new BpelServerConnector();
            this._connector.setBpelServer((BpelServer)this._ode._server);
            this._connector.setProcessStore((ProcessStore)this._ode._store);
            this._connector.setPort(this._ode._config.getConnectorPort());
            this._connector.setId(this._ode._config.getConnectorName());
            try {
                this._connector.start();
            }
            catch (Exception e) {
                __log.error((Object)"Failed to initialize JCA connector (check security manager configuration)");
                __log.debug((Object)"Failed to initialize JCA connector (check security manager configuration)", (Throwable)e);
            }
        }
    }

    private void registerMBean() throws JBIException {
        ProcessAndInstanceManagementMBean pmapi = new ProcessAndInstanceManagementMBean((BpelServer)this._ode._server, (ProcessStore)this._ode._store);
        MBeanServer server = this._ode.getContext().getMBeanServer();
        try {
            if (server != null) {
                this._mbeanName = this._ode.getContext().getMBeanNames().createCustomComponentMBeanName("Management");
                if (server.isRegistered(this._mbeanName)) {
                    server.unregisterMBean(this._mbeanName);
                }
                server.registerMBean(pmapi, this._mbeanName);
            }
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    private void unregisterMBean() throws JBIException {
        try {
            if (this._mbeanName != null) {
                MBeanServer server = this._ode.getContext().getMBeanServer();
                assert (server != null);
                if (server.isRegistered(this._mbeanName)) {
                    server.unregisterMBean(this._mbeanName);
                }
            }
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    private void registerEventListeners() {
        String listenersStr = this._ode._config.getEventListeners();
        if (listenersStr != null) {
            for (String listenerCN : listenersStr.split("\\s*(,|;)\\s*")) {
                try {
                    this._ode._server.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    __log.info((Object)__msgs.msgBpelEventListenerRegistered(listenerCN));
                }
                catch (Exception e) {
                    __log.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String listenersStr = this._ode._config.getMessageExchangeInterceptors();
        if (listenersStr != null) {
            for (String interceptorCN : listenersStr.split("\\s*(,|;)\\s*")) {
                try {
                    this._ode._server.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    __log.info((Object)__msgs.msgMessageExchangeInterceptorRegistered(interceptorCN));
                }
                catch (Exception e) {
                    __log.warn((Object)("Couldn't register the event listener " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws JBIException {
        if (this._started) {
            return;
        }
        try {
            __log.info((Object)__msgs.msgOdeStarting());
            if (!this._initSuccess) {
                String errmsg = "attempt to call start() after init() failure.";
                IllegalStateException ex = new IllegalStateException(errmsg);
                __log.fatal((Object)errmsg, (Throwable)ex);
                throw new JBIException(errmsg, (Throwable)ex);
            }
            if (this._ode.getChannel() == null) {
                throw new JBIException("No channel!", (Throwable)new NullPointerException());
            }
            try {
                this._ode._server.start();
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgOdeBpelServerStartFailure();
                __log.error((Object)errmsg, (Throwable)ex);
                throw new JBIException(errmsg, (Throwable)ex);
            }
            this._ode._scheduler.start();
            this._receiver = new Receiver(this._ode);
            this._receiver.start();
            this._started = true;
            __log.info((Object)__msgs.msgOdeStarted());
        }
        finally {
            if (!this._started) {
                if (this._receiver != null) {
                    this._receiver.cease();
                }
                this._receiver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws JBIException {
        if (!this._started) {
            return;
        }
        __log.info((Object)"Stopping ODE.");
        try {
            if (this._receiver != null) {
                try {
                    this._receiver.cease();
                }
                catch (Exception ex) {
                    __log.fatal((Object)"Error ceasing receiver.", (Throwable)ex);
                }
                finally {
                    this._receiver = null;
                }
            }
            try {
                this._ode._server.stop();
            }
            catch (Throwable ex) {
                __log.fatal((Object)"Error stopping services.", ex);
            }
            __log.info((Object)"ODE stopped.");
        }
        finally {
            this._started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws JBIException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.unregisterMBean();
        this._ode.deactivatePMAPIs();
        if (this._connector != null) {
            try {
                this._connector.shutdown();
            }
            catch (Exception e) {
                __log.error((Object)"Error shutting down JCA server.", (Throwable)e);
            }
            this._connector = null;
        }
        try {
            try {
                __log.debug((Object)"shutting down quartz scheduler.");
                this._ode._scheduler.shutdown();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this._db.shutdown();
            }
            catch (Exception ex) {
                __log.debug((Object)"error shutting down db.", (Throwable)ex);
            }
            finally {
                this._db = null;
            }
            __log.debug((Object)"cleaning up temporary files.");
            TempFileManager.cleanup();
            this._suManager = null;
            this._ode = null;
            __log.info((Object)"Shutdown completed.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

