/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.jbi.JbiMessageExchangeProcessor;
import org.apache.ode.jbi.MessageExchangePattern;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.jbi.ServiceBridge;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.msgmap.MessageTranslationException;
import org.w3c.dom.Element;

public class OdeService
extends ServiceBridge
implements JbiMessageExchangeProcessor {
    private static final Log __log = LogFactory.getLog(OdeService.class);
    private final JbiMexTracker _jbiMexTracker = new JbiMexTracker();
    private ServiceEndpoint _internal;
    private ServiceEndpoint _external;
    private OdeContext _ode;
    private Element _serviceref;
    private Endpoint _endpoint;
    private int count;

    public OdeService(OdeContext odeContext, Endpoint endpoint) throws Exception {
        this._ode = odeContext;
        this._endpoint = endpoint;
    }

    public int getCount() {
        return this.count;
    }

    public void activate() throws JBIException {
        ServiceEndpoint[] candidates;
        ++this.count;
        if (this.count != 1) {
            return;
        }
        if (this._serviceref == null && (candidates = this._ode.getContext().getExternalEndpointsForService(this._endpoint.serviceName)).length != 0) {
            this._external = candidates[0];
        }
        this._internal = this._ode.getContext().activateEndpoint(this._endpoint.serviceName, this._endpoint.portName);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Activated endpoint " + this._endpoint));
        }
    }

    public void deactivate() throws JBIException {
        --this.count;
        if (this.count != 0) {
            return;
        }
        this._ode.getContext().deactivateEndpoint(this._internal);
        __log.debug((Object)("Dectivated endpoint " + this._endpoint));
    }

    public ServiceEndpoint getInternalServiceEndpoint() {
        return this._internal;
    }

    public ServiceEndpoint getExternalServiceEndpoint() {
        return this._external;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJbiMessageExchange(MessageExchange jbiMex) throws MessagingException {
        if (jbiMex.getRole() != MessageExchange.Role.PROVIDER) {
            String errmsg = "Message exchange is not in PROVIDER role as expected: " + jbiMex.getExchangeId();
            __log.fatal((Object)errmsg);
            throw new IllegalArgumentException(errmsg);
        }
        if (jbiMex.getStatus() != ExchangeStatus.ACTIVE) {
            __log.debug((Object)("Consuming MEX tracker " + jbiMex.getExchangeId()));
            this._jbiMexTracker.consume(jbiMex.getExchangeId());
            return;
        }
        if (jbiMex.getOperation() == null) {
            throw new IllegalArgumentException("Null operation in JBI message exchange id=" + jbiMex.getExchangeId() + " endpoint=" + this._endpoint);
        }
        if (jbiMex.getPattern().equals(MessageExchangePattern.IN_ONLY)) {
            boolean success = false;
            Exception err = null;
            try {
                this.invokeOde(jbiMex, ((InOnly)jbiMex).getInMessage());
                success = true;
            }
            catch (Exception ex) {
                __log.error((Object)"Error invoking ODE.", (Throwable)ex);
                err = ex;
            }
            finally {
                if (!success) {
                    jbiMex.setStatus(ExchangeStatus.ERROR);
                    if (err != null && jbiMex.getError() == null) {
                        jbiMex.setError(err);
                    }
                } else if (jbiMex.getStatus() == ExchangeStatus.ACTIVE) {
                    jbiMex.setStatus(ExchangeStatus.DONE);
                }
                this._ode.getChannel().send(jbiMex);
            }
        } else if (jbiMex.getPattern().equals(MessageExchangePattern.IN_OUT)) {
            boolean success = false;
            Exception err = null;
            try {
                this.invokeOde(jbiMex, ((InOut)jbiMex).getInMessage());
                success = true;
            }
            catch (Exception ex) {
                __log.error((Object)"Error invoking ODE.", (Throwable)ex);
                err = ex;
            }
            catch (Throwable t) {
                __log.error((Object)"Unexpected error invoking ODE.", t);
                err = new RuntimeException(t);
            }
            finally {
                if (jbiMex.getStatus() == ExchangeStatus.ACTIVE && !success) {
                    if (err != null && jbiMex.getError() == null) {
                        jbiMex.setError(err);
                    }
                    jbiMex.setStatus(ExchangeStatus.ERROR);
                    this._ode.getChannel().send(jbiMex);
                }
            }
        } else {
            __log.error((Object)("JBI MessageExchange " + jbiMex.getExchangeId() + " is of an unsupported pattern " + jbiMex.getPattern()));
            jbiMex.setStatus(ExchangeStatus.ERROR);
            jbiMex.setError(new Exception("Unknown message exchange pattern: " + jbiMex.getPattern()));
        }
    }

    public void onResponse(MyRoleMessageExchange mex) {
        final String clientId = mex.getClientId();
        final String mexId = mex.getMessageExchangeId();
        __log.debug((Object)("Processing MEX tracker mexId: " + mexId + " clientId: " + clientId));
        final MessageExchange jbiMex = this._jbiMexTracker.peek(clientId);
        if (jbiMex == null) {
            __log.warn((Object)("Ignoring unknown async reply. mexId: " + mexId + " clientId: " + clientId));
            return;
        }
        try {
            switch (mex.getStatus()) {
                case FAULT: {
                    this.outResponseFault(mex, jbiMex);
                    break;
                }
                case RESPONSE: {
                    this.outResponse(mex, jbiMex);
                    break;
                }
                case FAILURE: {
                    this.outFailure(mex, jbiMex);
                    break;
                }
                default: {
                    __log.warn((Object)("Received ODE message exchange in unexpected state: " + mex.getStatus() + " mexId: " + mexId + " clientId: " + clientId));
                }
            }
            mex.release(mex.getStatus() == MessageExchange.Status.RESPONSE);
            this._ode._scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    if (success) {
                        try {
                            OdeService.this._ode.getChannel().send(jbiMex);
                            __log.debug((Object)("Consuming MEX tracker mexId: " + mexId + " clientId: " + clientId));
                            OdeService.this._jbiMexTracker.consume(clientId);
                        }
                        catch (MessagingException e) {
                            __log.error((Object)("Error delivering response from ODE to JBI mexId: " + mexId + " clientId: " + clientId), (Throwable)e);
                        }
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (MessagingException e) {
            __log.error((Object)("Error processing response from ODE to JBI mexId: " + mexId + " clientId: " + clientId), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOde(MessageExchange jbiMex, NormalizedMessage request) throws Exception {
        block13: {
            MyRoleMessageExchange odeMex;
            block12: {
                if (this._jbiMexTracker.track(jbiMex)) {
                    __log.debug((Object)("Skipping JBI MEX " + jbiMex.getExchangeId() + ", already received!"));
                    return;
                }
                this._ode.getTransactionManager().begin();
                boolean success = false;
                odeMex = null;
                try {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("invokeOde() JBI exchangeId=" + jbiMex.getExchangeId() + " endpoint=" + this._endpoint + " operation=" + jbiMex.getOperation()));
                    }
                    if ((odeMex = this._ode._server.getEngine().createMessageExchange(jbiMex.getExchangeId(), this._endpoint.serviceName, jbiMex.getOperation().getLocalPart())).getOperation() != null) {
                        this.copyMexProperties(odeMex, jbiMex);
                        Message msgdef = odeMex.getOperation().getInput().getMessage();
                        org.apache.ode.bpel.iapi.Message odeRequest = odeMex.createMessage(odeMex.getOperation().getInput().getMessage().getQName());
                        Mapper mapper = this._ode.findMapper(request, odeMex.getOperation());
                        if (mapper == null) {
                            String errmsg = "Could not find a mapper for request message for JBI MEX " + jbiMex.getExchangeId() + "; ODE MEX " + odeMex.getMessageExchangeId() + " is failed. ";
                            __log.error((Object)errmsg);
                            throw new MessageTranslationException(errmsg);
                        }
                        odeMex.setProperty(Mapper.class.getName(), mapper.getClass().getName());
                        mapper.toODE(odeRequest, request, msgdef);
                        odeMex.invoke(odeRequest);
                        if (odeMex.getStatus() != MessageExchange.Status.ASYNC) {
                            __log.debug((Object)("ODE MEX " + odeMex + " completed SYNCHRONOUSLY."));
                            this.onResponse(odeMex);
                            this._jbiMexTracker.consume(jbiMex.getExchangeId());
                        } else {
                            __log.debug((Object)("ODE MEX " + odeMex + " completed ASYNCHRONOUSLY."));
                        }
                    } else {
                        __log.error((Object)("ODE MEX " + odeMex + " was unroutable."));
                        this.setError(jbiMex, new IllegalArgumentException("Unroutable invocation."));
                    }
                    success = true;
                    if (jbiMex.getPattern().equals(MessageExchangePattern.IN_ONLY)) {
                        __log.debug((Object)("Consuming non Req/Res MEX tracker " + jbiMex.getExchangeId() + " with pattern " + jbiMex.getPattern()));
                        this._jbiMexTracker.consume(jbiMex.getExchangeId());
                    }
                    if (!success) break block12;
                }
                catch (Throwable throwable) {
                    if (success) {
                        __log.debug((Object)("Commiting ODE MEX " + odeMex));
                        this._ode.getTransactionManager().commit();
                    } else {
                        __log.debug((Object)("Rolling back ODE MEX " + odeMex));
                        this._jbiMexTracker.consume(jbiMex.getExchangeId());
                        this._ode.getTransactionManager().rollback();
                    }
                    throw throwable;
                }
                __log.debug((Object)("Commiting ODE MEX " + odeMex));
                this._ode.getTransactionManager().commit();
                break block13;
            }
            __log.debug((Object)("Rolling back ODE MEX " + odeMex));
            this._jbiMexTracker.consume(jbiMex.getExchangeId());
            this._ode.getTransactionManager().rollback();
        }
    }

    private void outFailure(MyRoleMessageExchange odeMex, MessageExchange jbiMex) throws MessagingException {
        jbiMex.setError(new Exception("MEXFailure"));
        jbiMex.setStatus(ExchangeStatus.ERROR);
    }

    private void outResponse(MyRoleMessageExchange mex, MessageExchange jbiMex) throws MessagingException {
        InOut inout = (InOut)jbiMex;
        try {
            NormalizedMessage nmsg = inout.createMessage();
            String mapperName = mex.getProperty(Mapper.class.getName());
            Mapper mapper = this._ode.getMapper(mapperName);
            if (mapper == null) {
                String errmsg = "Message-mapper " + mapperName + " used in ODE MEX " + mex.getMessageExchangeId() + " is no longer available.";
                __log.error((Object)errmsg);
                throw new MessageTranslationException(errmsg);
            }
            mapper.toNMS(nmsg, mex.getResponse(), mex.getOperation().getOutput().getMessage(), null);
            inout.setOutMessage(nmsg);
        }
        catch (MessageTranslationException e) {
            __log.error((Object)("Error translating ODE message " + mex.getResponse() + " to NMS format!"), (Throwable)e);
            this.setError(jbiMex, e);
        }
    }

    private void outResponseFault(MyRoleMessageExchange mex, MessageExchange jbiMex) throws MessagingException {
        InOut inout = (InOut)jbiMex;
        try {
            Fault flt = inout.createFault();
            String mapperName = mex.getProperty(Mapper.class.getName());
            Mapper mapper = this._ode.getMapper(mapperName);
            if (mapper == null) {
                String errmsg = "Message-mapper " + mapperName + " used in ODE MEX " + mex.getMessageExchangeId() + " is no longer available.";
                __log.error((Object)errmsg);
                throw new MessageTranslationException(errmsg);
            }
            QName fault = mex.getFault();
            javax.wsdl.Fault wsdlFault = mex.getOperation().getFault(fault.getLocalPart());
            if (wsdlFault == null) {
                this.setError(jbiMex, new MessageTranslationException("Unmapped Fault : " + fault + ": " + mex.getFaultExplanation()));
            } else {
                mapper.toNMS((NormalizedMessage)flt, mex.getFaultResponse(), wsdlFault.getMessage(), fault);
                inout.setFault(flt);
            }
        }
        catch (MessageTranslationException mte) {
            __log.error((Object)("Error translating ODE fault message " + mex.getFaultResponse() + " to NMS format!"), (Throwable)mte);
            this.setError(jbiMex, mte);
        }
    }

    private void setError(MessageExchange jbiMex, Exception error) throws MessagingException {
        jbiMex.setError(error);
        jbiMex.setStatus(ExchangeStatus.ERROR);
    }

    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    private static class JbiMexTracker {
        private Map<String, MessageExchange> _outstandingJbiExchanges = new HashMap<String, MessageExchange>();

        private JbiMexTracker() {
        }

        synchronized boolean track(MessageExchange jbiMex) {
            boolean found = this._outstandingJbiExchanges.containsKey(jbiMex.getExchangeId());
            this._outstandingJbiExchanges.put(jbiMex.getExchangeId(), jbiMex);
            return found;
        }

        synchronized MessageExchange peek(String clientId) {
            return this._outstandingJbiExchanges.get(clientId);
        }

        synchronized MessageExchange consume(String clientId) {
            return this._outstandingJbiExchanges.remove(clientId);
        }
    }
}

