/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jbi.management.DeploymentException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.Messages;
import org.apache.ode.jbi.OdeContext;

class OdeServiceUnit {
    private static final Log __log = LogFactory.getLog(OdeServiceUnit.class);
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private OdeContext _ode;
    private File _serviceUnitRootPath;
    private String _serviceUnitID;
    private Collection<QName> _registered = new ArrayList<QName>();
    private static final String LIB_DIR = "lib";

    OdeServiceUnit(OdeContext ode, String serviceUnitID, String serviceUnitRootPath) {
        this._ode = ode;
        this._serviceUnitID = serviceUnitID;
        this._serviceUnitRootPath = new File(serviceUnitRootPath);
    }

    public void deploy() throws DeploymentException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getConfigurationClassLoader());
            this._ode._store.deploy(this._serviceUnitRootPath, false);
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeProcessDeploymentFailed(this._serviceUnitRootPath, this._serviceUnitID);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void undeploy() throws Exception {
        try {
            Collection undeployed = this._ode._store.undeploy(this._serviceUnitRootPath);
            for (QName pqname : undeployed) {
                this._ode._server.unregister(pqname);
            }
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeProcessUndeploymentFailed(null);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DeploymentException(errmsg, (Throwable)ex);
        }
    }

    public void init() throws Exception {
    }

    public void shutdown() throws Exception {
    }

    public void start() throws Exception {
        List pids = this._ode._store.listProcesses(this._serviceUnitRootPath.getName());
        if (pids == null) {
            __log.error((Object)(this._serviceUnitRootPath.getName() + " not found in process store. "));
            throw new IllegalStateException("Process store and JBI out of synch.");
        }
        Exception e = null;
        for (QName pid : pids) {
            try {
                this._ode._server.register(this._ode._store.getProcessConfiguration(pid));
                this._registered.add(pid);
            }
            catch (Exception ex) {
                e = ex;
                __log.error((Object)("Unable to load " + pid), (Throwable)ex);
                break;
            }
        }
        if (this._registered.size() != pids.size()) {
            for (QName pid : new ArrayList<QName>(this._registered)) {
                try {
                    this._ode._server.unregister(pid);
                    this._registered.remove(pid);
                }
                catch (Exception ex) {
                    __log.error((Object)("Unable to unload " + pid), (Throwable)ex);
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void stop() throws Exception {
        for (QName pid : new ArrayList<QName>(this._registered)) {
            try {
                this._ode._server.unregister(pid);
                this._registered.remove(pid);
            }
            catch (Exception ex) {
                __log.error((Object)("Unable to unload " + pid), (Throwable)ex);
            }
        }
    }

    public ClassLoader getConfigurationClassLoader() throws DeploymentException {
        return new URLClassLoader(this.getDefaultLocations(), this.getClass().getClassLoader());
    }

    protected URL[] getDefaultLocations() throws DeploymentException {
        try {
            File[] jars = new File(this._serviceUnitRootPath, LIB_DIR).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars != null ? jars.length + 1 : 1];
            urls[0] = this._serviceUnitRootPath.toURI().toURL();
            if (jars != null) {
                for (int i = 0; i < jars.length; ++i) {
                    urls[i + 1] = jars[i].toURI().toURL();
                }
            }
            if (__log.isDebugEnabled()) {
                for (URL u : urls) {
                    __log.debug((Object)("in classpath for " + this._serviceUnitID + " using url: " + u));
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Unable to get default classpath locations", (Throwable)e);
        }
    }
}

