/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi.msgmap;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.msgmap.MessageTranslationException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseXmlMapper {
    protected Log __log = LogFactory.getLog(this.getClass());
    private static Map<Source, Document> __parsed = Collections.synchronizedMap(new WeakHashMap());

    protected BaseXmlMapper() {
    }

    protected Element parse(Source content) throws MessageTranslationException {
        Document parsed = __parsed.get(content);
        if (parsed != null) {
            return parsed.getDocumentElement();
        }
        try {
            parsed = DOMUtils.sourceToDOM((Source)content);
            __parsed.put(content, parsed);
            return parsed.getDocumentElement();
        }
        catch (Exception e) {
            throw new MessageTranslationException("Message parsing exception", e);
        }
    }

    protected Document newDocument() {
        return DOMUtils.newDocument();
    }
}

