/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi.msgmap;

import java.util.Collection;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.ode.jbi.msgmap.BaseXmlMapper;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.msgmap.MessageTranslationException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLitMapper
extends BaseXmlMapper
implements Mapper {
    @Override
    public Mapper.Recognized isRecognized(NormalizedMessage nmsMsg, Operation op) {
        Element msg;
        Message out;
        Message in = op.getInput() == null ? null : op.getInput().getMessage();
        Message message = out = op.getOutput() == null ? null : op.getOutput().getMessage();
        if (!this.checkMessageDef(in) || !this.checkMessageDef(out)) {
            return Mapper.Recognized.FALSE;
        }
        if (in == null) {
            return Mapper.Recognized.UNSURE;
        }
        Part inpart = (Part)in.getParts().values().iterator().next();
        assert (inpart != null);
        assert (inpart.getElementName() != null);
        try {
            msg = this.parse(nmsMsg.getContent());
        }
        catch (MessageTranslationException e) {
            this.__log.debug((Object)("Failed to parse NMS message: " + nmsMsg), (Throwable)e);
            return Mapper.Recognized.FALSE;
        }
        QName elName = DOMUtils.getNodeQName((Node)msg);
        return inpart.getElementName().equals(elName) ? Mapper.Recognized.TRUE : Mapper.Recognized.FALSE;
    }

    @Override
    public void toNMS(NormalizedMessage nmsMsg, org.apache.ode.bpel.iapi.Message odeMsg, Message msgdef, QName fault) throws MessagingException, MessageTranslationException {
        if (msgdef == null && fault != null) {
            Document doc = this.newDocument();
            Element content = doc.createElementNS(fault.getNamespaceURI(), fault.getLocalPart());
            doc.appendChild(content);
            nmsMsg.setContent((Source)new DOMSource(doc));
            return;
        }
        if (msgdef == null || msgdef.getParts().size() == 0) {
            return;
        }
        assert (msgdef.getParts().size() == 1) : "multi part!";
        Part partdef = (Part)msgdef.getParts().values().iterator().next();
        assert (partdef.getElementName() != null) : "non-element part!";
        if (odeMsg.getMessage() == null) {
            String errmsg = "Unknown fault: " + odeMsg.getType();
            this.__log.debug((Object)errmsg);
            throw new MessageTranslationException(errmsg);
        }
        Element part = DOMUtils.findChildByName((Element)odeMsg.getMessage(), (QName)new QName(null, partdef.getName()));
        if (part == null) {
            String errmsg = "ODE message did not contain expected part: " + partdef.getName();
            this.__log.debug((Object)errmsg);
            throw new MessageTranslationException(errmsg);
        }
        Element content = DOMUtils.findChildByName((Element)part, (QName)partdef.getElementName());
        if (content == null) {
            String errmsg = "ODE message did not contain element " + partdef.getElementName() + " in part: " + partdef.getName();
            this.__log.debug((Object)errmsg);
            throw new MessageTranslationException(errmsg);
        }
        nmsMsg.setContent((Source)new DOMSource(content));
    }

    @Override
    public void toODE(org.apache.ode.bpel.iapi.Message odeMsg, NormalizedMessage nmsMsg, Message msgdef) throws MessageTranslationException {
        assert (msgdef.getParts().size() == 1) : "multi part!";
        Part partdef = (Part)msgdef.getParts().values().iterator().next();
        assert (partdef.getElementName() != null) : "non-element part!";
        Element el = this.parse(nmsMsg.getContent());
        if (!DOMUtils.getNodeQName((Node)el).equals(partdef.getElementName())) {
            String errmsg = "NMS message did not contain element " + partdef.getElementName();
            this.__log.debug((Object)errmsg);
            throw new MessageTranslationException(errmsg);
        }
        Document doc = this.newDocument();
        Element msgel = doc.createElement("message");
        doc.appendChild(msgel);
        Element pel = doc.createElement(partdef.getName());
        msgel.appendChild(pel);
        pel.appendChild(doc.importNode(el, true));
        odeMsg.setMessage(msgel);
    }

    @Override
    public javax.wsdl.Fault toFaultType(Fault jbiFlt, Collection<javax.wsdl.Fault> faults) throws MessageTranslationException {
        Element el = this.parse(jbiFlt.getContent());
        QName elQname = new QName(el.getNamespaceURI(), el.getLocalName());
        for (javax.wsdl.Fault f : faults) {
            Part pdef;
            if (f.getMessage() == null || f.getMessage().getParts().size() != 1 || (pdef = (Part)f.getMessage().getParts().values().iterator().next()).getElementName() == null || !pdef.getElementName().equals(elQname)) continue;
            return f;
        }
        return null;
    }

    private boolean checkMessageDef(Message msg) {
        if (msg == null) {
            return true;
        }
        if (msg.getParts().size() != 1) {
            return false;
        }
        return ((Part)msg.getParts().values().iterator().next()).getElementName() != null;
    }
}

