/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi.msgmap;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.ode.jbi.msgmap.BaseXmlMapper;
import org.apache.ode.jbi.msgmap.Mapper;
import org.apache.ode.jbi.msgmap.MessageTranslationException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixMapper
extends BaseXmlMapper
implements Mapper {
    @Override
    public Mapper.Recognized isRecognized(NormalizedMessage nmsMsg, Operation op) {
        Part part;
        QName elementName;
        Element msg;
        if (nmsMsg.getClass().getName().indexOf("servicemix") == -1) {
            this.__log.debug((Object)("Unrecognized message class: " + nmsMsg.getClass()));
            return Mapper.Recognized.FALSE;
        }
        try {
            msg = this.parse(nmsMsg.getContent());
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("isRecognized() message: " + this.prettyPrint(msg)));
            }
        }
        catch (MessageTranslationException e) {
            this.__log.warn((Object)"Unable to parse message: ", (Throwable)e);
            return Mapper.Recognized.FALSE;
        }
        if (op.getInput() == null) {
            this.__log.debug((Object)"no input def - unrecognized");
            return Mapper.Recognized.FALSE;
        }
        if (op.getInput().getMessage() == null) {
            this.__log.debug((Object)"no message def - unrecognized");
            return Mapper.Recognized.FALSE;
        }
        if (op.getInput().getMessage().getParts().size() == 0) {
            this.__log.debug((Object)"no message parts def - unsure");
            return Mapper.Recognized.UNSURE;
        }
        this.__log.debug((Object)"Recognizing document content");
        if (op.getInput().getMessage().getParts().size() == 1 && (elementName = (part = (Part)op.getInput().getMessage().getParts().values().iterator().next()).getElementName()) != null && elementName.getLocalPart().equals(msg.getLocalName()) && elementName.getNamespaceURI().equals(msg.getNamespaceURI())) {
            this.__log.debug((Object)"Recognized");
            return Mapper.Recognized.TRUE;
        }
        this.__log.debug((Object)"Recognizing RPC style content");
        for (String pname : op.getInput().getMessage().getParts().keySet()) {
            Part part2 = op.getInput().getMessage().getPart(pname);
            if (part2.getElementName() != null) {
                this.__log.debug((Object)("Part " + part2.getName() + " has element content " + part2.getElementName() + ". It's not allowed for RPC style."));
                return Mapper.Recognized.FALSE;
            }
            Element pdata = DOMUtils.findChildByName((Element)msg, (QName)new QName(null, part2.getName()));
            if (pdata != null) continue;
            this.__log.debug((Object)("no part data for " + part2.getName() + " -- unrecognized."));
            return Mapper.Recognized.FALSE;
        }
        return Mapper.Recognized.TRUE;
    }

    @Override
    public void toNMS(NormalizedMessage nmsMsg, org.apache.ode.bpel.iapi.Message odeMsg, Message msgdef, QName fault) throws MessagingException, MessageTranslationException {
        Element firstPartEl;
        if (msgdef == null) {
            throw new NullPointerException("msdef must not be null.");
        }
        Map headers = odeMsg.getHeaderParts();
        if (headers != null) {
            for (String header : headers.keySet()) {
                HashMap<QName, DocumentFragment> headers2;
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("toNMS() header " + header + " := " + DOMUtils.domToString((Node)((Node)headers.get(header)))));
                }
                if ((headers2 = (HashMap<QName, DocumentFragment>)nmsMsg.getProperty("org.apache.servicemix.soap.headers")) == null) {
                    headers2 = new HashMap<QName, DocumentFragment>();
                    nmsMsg.setProperty("org.apache.servicemix.soap.headers", headers2);
                }
                Node v = (Node)headers.get(header);
                DocumentFragment f = v.getOwnerDocument().createDocumentFragment();
                f.appendChild(v);
                headers2.put(QName.valueOf(header), f);
            }
        }
        Element ode = odeMsg == null ? null : odeMsg.getMessage();
        Element part = ode == null ? null : DOMUtils.getFirstChildElement((Element)ode);
        Element element = firstPartEl = part == null ? null : DOMUtils.getFirstChildElement((Element)part);
        if (fault != null) {
            if (msgdef.getParts().size() != 1) {
                throw new MessageTranslationException("Message for fault \"" + fault + "\" does not contain exactly one part! Cannot map!");
            }
            Part partDef = (Part)msgdef.getParts().values().iterator().next();
            if (partDef.getElementName() == null) {
                throw new MessageTranslationException("Message for fault \"" + fault + "\" does not contain an element part.");
            }
            if (firstPartEl == null) {
                this.__log.warn((Object)("Proceessing fault \"" + fault + "\" with empty content (check your BPEL)."));
                Document doc = this.newDocument();
                Element content = doc.createElementNS(partDef.getElementName().getNamespaceURI(), partDef.getElementName().getLocalPart());
                doc.appendChild(content);
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("toNMS() ode message (fault, BS): " + this.prettyPrint(content)));
                }
                nmsMsg.setContent((Source)new DOMSource(doc));
            } else {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("toNMS() ode message (fault): " + this.prettyPrint(firstPartEl)));
                }
                nmsMsg.setContent((Source)new DOMSource(firstPartEl));
            }
            return;
        }
        if (msgdef.getParts().size() == 0) {
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)"toNMS() ode message (rpc-like): no parts");
            }
            nmsMsg.setContent(null);
            return;
        }
        if (msgdef.getParts().size() != 1 || ((Part)msgdef.getParts().values().iterator().next()).getElementName() == null) {
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("toNMS() ode message (rpc-like): " + this.prettyPrint(ode)));
            }
            nmsMsg.setContent((Source)new DOMSource(ode));
            return;
        }
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("toNMS() normalized message (doc-like):" + this.prettyPrint(firstPartEl)));
        }
        nmsMsg.setContent((Source)new DOMSource(firstPartEl));
    }

    @Override
    public void toODE(org.apache.ode.bpel.iapi.Message odeMsg, NormalizedMessage nmsMsg, Message msgdef) throws MessageTranslationException {
        if (nmsMsg.getContent() == null) {
            Document doc = this.newDocument();
            Element message = doc.createElement("message");
            odeMsg.setMessage(message);
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("toODE() normalized message:\n" + this.prettyPrint(message)));
            }
            return;
        }
        Element nms = this.parse(nmsMsg.getContent());
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("toODE() normalized message:\n" + this.prettyPrint(nms)));
        }
        boolean docLit = false;
        for (String pname : msgdef.getParts().keySet()) {
            Part part = msgdef.getPart(pname);
            QName elementName = part.getElementName();
            if (elementName == null || !elementName.getLocalPart().equals(nms.getLocalName()) || !elementName.getNamespaceURI().equals(nms.getNamespaceURI())) continue;
            docLit = true;
            break;
        }
        if (docLit) {
            this.__log.debug((Object)"toODE() doc-like message ");
            Document doc = this.newDocument();
            Element message = doc.createElement("message");
            doc.appendChild(message);
            Part firstPart = (Part)msgdef.getOrderedParts(null).get(0);
            Element p = doc.createElement(firstPart.getName());
            message.appendChild(p);
            p.appendChild(doc.importNode(nms, true));
            odeMsg.setMessage(message);
        } else {
            this.__log.debug((Object)"toODE() rpc-like message ");
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("toODE() ode message:\n" + this.prettyPrint(nms)));
            }
            odeMsg.setMessage(nms);
        }
        Map headers = (Map)nmsMsg.getProperty("org.apache.servicemix.soap.headers");
        if (headers != null) {
            for (QName header : headers.keySet()) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("toODE() header " + header + " := " + DOMUtils.domToString((Node)((Node)headers.get(header)))));
                }
                try {
                    odeMsg.setHeaderPart(header.getLocalPart(), DOMUtils.stringToDOM((String)DOMUtils.domToString((Node)((Node)headers.get(header)))));
                }
                catch (Exception e) {
                    this.__log.error((Object)("Can't copy input header " + header));
                }
            }
        }
    }

    @Override
    public javax.wsdl.Fault toFaultType(Fault jbiFlt, Collection<javax.wsdl.Fault> faults) throws MessageTranslationException {
        if (faults.isEmpty()) {
            return null;
        }
        return faults.iterator().next();
    }

    private String prettyPrint(Element el) {
        try {
            return DOMUtils.prettyPrint((Element)el);
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
    }
}

