/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi.util;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jbi.util.Schema;
import org.apache.ode.jbi.util.SchemaCollection;

public class WSDLFlattener {
    private static Log __log = LogFactory.getLog(WSDLFlattener.class);
    private Definition _definition;
    private SchemaCollection _schemas;
    private Map<QName, Definition> _flattened;
    private boolean _initialized;

    public WSDLFlattener(Definition definition) {
        this(definition, null);
    }

    public WSDLFlattener(Definition definition, SchemaCollection schemas) {
        if (definition == null) {
            throw new NullPointerException("Null definition!");
        }
        this._definition = definition;
        this._flattened = new ConcurrentHashMap<QName, Definition>();
        this._schemas = schemas;
    }

    public void initialize() throws Exception {
        if (!this._initialized) {
            if (this._schemas == null) {
                this._schemas = new SchemaCollection(this.getUri(this._definition.getDocumentBaseURI()));
            }
            this.parseSchemas(this._definition);
            this._initialized = true;
        }
    }

    public Definition getDefinition(QName portType) throws Exception {
        Definition def = this._flattened.get(portType);
        if (def == null) {
            def = this.flattenDefinition(portType);
            this._flattened.put(portType, def);
        }
        return def;
    }

    public Definition getDefinition() {
        return this._definition;
    }

    public void setDefinition(Definition definition) {
        this._definition = definition;
    }

    public SchemaCollection getSchemas() throws Exception {
        return this._schemas;
    }

    public void setSchemas(SchemaCollection schemas) {
        this._schemas = schemas;
    }

    private Definition flattenDefinition(QName name) throws Exception {
        this.initialize();
        Definition flat = WSDLFactory.newInstance().newDefinition();
        flat.setTargetNamespace(name.getNamespaceURI());
        this.addNamespaces(flat, this._definition);
        PortType defPort = this._definition.getPortType(name);
        PortType flatPort = flat.createPortType();
        flatPort.setQName(defPort.getQName());
        flatPort.setUndefined(false);
        for (Operation defOper : defPort.getOperations()) {
            Operation flatOper = flat.createOperation();
            flatOper.setName(defOper.getName());
            flatOper.setStyle(defOper.getStyle());
            flatOper.setUndefined(false);
            if (defOper.getInput() != null) {
                Input flatInput = flat.createInput();
                flatInput.setName(defOper.getInput().getName());
                if (defOper.getInput().getMessage() != null) {
                    Message flatInputMsg = this.copyMessage(defOper.getInput().getMessage(), flat);
                    flatInput.setMessage(flatInputMsg);
                    flat.addMessage(flatInputMsg);
                }
                flatOper.setInput(flatInput);
            }
            if (defOper.getOutput() != null) {
                Output flatOutput = flat.createOutput();
                flatOutput.setName(defOper.getOutput().getName());
                if (defOper.getOutput().getMessage() != null) {
                    Message flatOutputMsg = this.copyMessage(defOper.getOutput().getMessage(), flat);
                    flatOutput.setMessage(flatOutputMsg);
                    flat.addMessage(flatOutputMsg);
                }
                flatOper.setOutput(flatOutput);
            }
            for (Fault defFault : defOper.getFaults().values()) {
                Fault flatFault = flat.createFault();
                flatFault.setName(defFault.getName());
                if (defFault.getMessage() != null) {
                    Message flatFaultMsg = this.copyMessage(defFault.getMessage(), flat);
                    flatFault.setMessage(flatFaultMsg);
                    flat.addMessage(flatFaultMsg);
                }
                flatOper.addFault(flatFault);
            }
            flatPort.addOperation(flatOper);
        }
        if (this._schemas.getSize() > 0) {
            Types types = flat.createTypes();
            Iterator it = this._schemas.getSchemas().iterator();
            while (it.hasNext()) {
                SchemaImpl imp = new SchemaImpl();
                imp.setElement(((Schema)it.next()).getRoot());
                imp.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                types.addExtensibilityElement((ExtensibilityElement)imp);
            }
            flat.setTypes(types);
        }
        flat.addPortType(flatPort);
        return flat;
    }

    private void parseSchemas(Definition def) throws Exception {
        if (def.getTypes() != null && def.getTypes().getExtensibilityElements() != null) {
            for (ExtensibilityElement element : def.getTypes().getExtensibilityElements()) {
                if (!(element instanceof javax.wsdl.extensions.schema.Schema)) continue;
                javax.wsdl.extensions.schema.Schema schema = (javax.wsdl.extensions.schema.Schema)element;
                if (schema.getElement() != null) {
                    this._schemas.read(schema.getElement(), this.getUri(schema.getDocumentBaseURI()));
                }
                for (Collection imps : schema.getImports().values()) {
                    for (SchemaImport imp : imps) {
                        this._schemas.read(imp.getSchemaLocationURI(), this.getUri(def.getDocumentBaseURI()));
                    }
                }
            }
        }
        if (def.getImports() != null) {
            for (Collection imps : def.getImports().values()) {
                for (Import imp : imps) {
                    this.parseSchemas(imp.getDefinition());
                }
            }
        }
    }

    private void addNamespaces(Definition flat, Definition def) {
        for (List defImports : def.getImports().values()) {
            for (Import defImport : defImports) {
                this.addNamespaces(flat, defImport.getDefinition());
            }
        }
        for (String key : def.getNamespaces().keySet()) {
            String val = def.getNamespace(key);
            flat.addNamespace(key, val);
        }
    }

    private Message copyMessage(Message defMessage, Definition flat) {
        Message flatMsg = flat.createMessage();
        flatMsg.setUndefined(false);
        if (defMessage.getQName() != null) {
            flatMsg.setQName(new QName(flat.getTargetNamespace(), defMessage.getQName().getLocalPart()));
        }
        for (Part defPart : defMessage.getParts().values()) {
            Part flatPart = flat.createPart();
            flatPart.setName(defPart.getName());
            flatPart.setElementName(defPart.getElementName());
            flatMsg.addPart(flatPart);
        }
        return flatMsg;
    }

    private URI getUri(String str) {
        if (str != null) {
            str = str.replaceAll(" ", "%20");
            return URI.create(str);
        }
        return null;
    }
}

