/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.stl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ode.utils.stl.UnaryFunction;

public class FilterIterator<T>
implements Iterator<T> {
    private UnaryFunction<T, Boolean> _mf;
    private Iterator<T> _i;
    private T _next;

    public FilterIterator(Iterator<T> i, UnaryFunction<T, Boolean> mf) {
        this._i = i;
        this._mf = mf;
    }

    @Override
    public boolean hasNext() {
        return this.doNext();
    }

    @Override
    public T next() {
        if (this.doNext()) {
            T ret = this._next;
            this._next = null;
            return ret;
        }
        throw new NoSuchElementException("No more elements.");
    }

    @Override
    public void remove() {
        if (this.doNext()) {
            this._next = null;
            this._i.remove();
        }
        throw new NoSuchElementException("No more elements.");
    }

    private boolean doNext() {
        if (this._next != null) {
            return true;
        }
        while (this._i.hasNext()) {
            T next = this._i.next();
            if (this._mf.apply(next) != Boolean.TRUE) continue;
            this._next = next;
            return true;
        }
        return false;
    }
}

