/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ode.utils.SystemConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLParserUtils {
    public static final String NAMESPACES_SAXF = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_SAXF = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_V_XERCESF = "http://apache.org/xml/features/validation/schema";
    private static final String XERCES_P_ROOT = "http://apache.org/xml/properties/schema/";
    private static final String EXTERNAL_SCHEMA_LOC_XERCESP = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String EXTERNAL_SCHEMA_NNS_LOC_XERCESP = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public static SAXParserFactory getSAXParserFactory() {
        return new SAXParserFactoryImpl();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return new DocumentBuilderFactoryImpl();
    }

    public static void setNamespaces(XMLReader xr) {
        try {
            xr.setFeature(NAMESPACES_SAXF, true);
        }
        catch (SAXException snse) {
            throw new SystemConfigurationException(snse);
        }
    }

    public static XMLReader getXMLReader() {
        return new SAXParser();
    }

    public static DOMParser getDOMParser() {
        return new DOMParser();
    }

    public static void setExternalSchemaURL(XMLReader xr, String namespace, String u) throws SAXNotRecognizedException, SAXNotSupportedException {
        xr.setFeature(NAMESPACES_SAXF, true);
        if (namespace != null && namespace.length() > 0) {
            xr.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, namespace + " " + u);
        } else {
            xr.setProperty(EXTERNAL_SCHEMA_NNS_LOC_XERCESP, u);
        }
        xr.setFeature(VALIDATION_SAXF, true);
        xr.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static void setExternalSchemaURL(DOMParser dp, String namespace, String u) throws SAXNotRecognizedException, SAXNotSupportedException {
        dp.setFeature(VALIDATION_SAXF, true);
        dp.setFeature(SCHEMA_V_XERCESF, true);
        if (namespace != null && namespace.length() > 0) {
            dp.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, (Object)(namespace + " " + u));
        } else {
            dp.setProperty(EXTERNAL_SCHEMA_NNS_LOC_XERCESP, (Object)u);
        }
    }

    public static void addExternalSchemaURL(XMLReader xr, String namespace, String u) throws SAXNotRecognizedException, SAXNotSupportedException {
        xr.setFeature(VALIDATION_SAXF, true);
        xr.setFeature(SCHEMA_V_XERCESF, true);
        if (namespace == null || namespace.length() == 0) {
            XMLParserUtils.setExternalSchemaURL(xr, namespace, u);
            return;
        }
        String s = (String)xr.getProperty(EXTERNAL_SCHEMA_LOC_XERCESP);
        if (s == null) {
            XMLParserUtils.setExternalSchemaURL(xr, namespace, u);
            return;
        }
        StringTokenizer st = new StringTokenizer(s);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new RuntimeException("Property has been misconfigured; expected an even number of tokens.  Value was: " + s);
            }
            String value = st.nextToken();
            namespaces.put(key, value);
        }
        namespaces.put(namespace, u);
        StringBuffer sb = new StringBuffer();
        Iterator it = namespaces.keySet().iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            sb.append(ns);
            sb.append(' ');
            sb.append((String)namespaces.get(ns));
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        xr.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, sb.toString());
        xr.setFeature(VALIDATION_SAXF, true);
        xr.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static void addExternalSchemaURL(DOMParser dp, String namespace, String u) throws SAXNotRecognizedException, SAXNotSupportedException {
        dp.setFeature(VALIDATION_SAXF, true);
        dp.setFeature(SCHEMA_V_XERCESF, true);
        if (namespace == null || namespace.length() == 0) {
            XMLParserUtils.setExternalSchemaURL(dp, namespace, u);
            return;
        }
        String s = (String)dp.getProperty(EXTERNAL_SCHEMA_LOC_XERCESP);
        if (s == null) {
            XMLParserUtils.setExternalSchemaURL(dp, namespace, u);
            return;
        }
        StringTokenizer st = new StringTokenizer(s);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new RuntimeException("Property has been misconfigured; expected an even number of tokens.  Value was: " + s);
            }
            String value = st.nextToken();
            namespaces.put(key, value);
        }
        namespaces.put(namespace, u);
        StringBuffer sb = new StringBuffer();
        Iterator it = namespaces.keySet().iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            sb.append(ns);
            sb.append(' ');
            sb.append((String)namespaces.get(ns));
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        dp.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, (Object)sb.toString());
        dp.setFeature(VALIDATION_SAXF, true);
        dp.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static ContentHandler getXercesSerializer(OutputStream os) {
        XMLSerializer serializer = new XMLSerializer();
        OutputFormat format = new OutputFormat();
        format.setPreserveSpace(true);
        format.setOmitDocumentType(true);
        serializer.setOutputFormat(format);
        serializer.setOutputByteStream(os);
        return serializer;
    }
}

