/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xml.capture;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ode.utils.XMLParserUtils;
import org.apache.ode.utils.xml.capture.MultiplexTracker;
import org.apache.ode.utils.xml.capture.Tracker;
import org.apache.ode.utils.xml.capture.Wsdl11Tracker;
import org.apache.ode.utils.xml.capture.XmlSchemaTracker;
import org.xml.sax.EntityResolver;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDependencyScanner {
    private Map<URI, Exception> _errors = new HashMap<URI, Exception>();
    private Map<URI, Set<URI>> _references = new HashMap<URI, Set<URI>>();
    private Map<URI, Set<URI>> _referers = new HashMap<URI, Set<URI>>();
    private EntityResolver _resolver;
    private MultiplexTracker _mch;

    public XmlDependencyScanner() {
        HashSet<Tracker> handlers = new HashSet<Tracker>();
        handlers.add(new Wsdl11Tracker());
        handlers.add(new XmlSchemaTracker());
        this._mch = new MultiplexTracker(handlers);
    }

    public void setResolver(EntityResolver resolver) {
        this._resolver = resolver;
    }

    public EntityResolver getResolver() {
        return this._resolver;
    }

    public void process(URI uri) {
        if (this._references.keySet().contains(uri)) {
            return;
        }
        HashSet<URI> todo = new HashSet<URI>();
        todo.add(uri);
        while (!todo.isEmpty()) {
            Iterator i = todo.iterator();
            URI x = (URI)i.next();
            i.remove();
            HashSet<URI> refs = new HashSet<URI>();
            this._mch.init(x, refs);
            try {
                XMLReader reader = XMLParserUtils.getXMLReader();
                reader.setContentHandler(this._mch);
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                reader.setEntityResolver(this._resolver);
                reader.parse(x.toASCIIString());
                this._references.put(x, new HashSet<URI>(refs));
            }
            catch (Exception e) {
                this._errors.put(x, e);
            }
            Iterator<URI> i1 = refs.iterator();
            while (i1.hasNext()) {
                this.addReferer(i1.next(), x);
            }
            refs.removeAll(this._references.keySet());
            todo.addAll(refs);
        }
    }

    public Set<URI> getURIs() {
        return this._references.keySet();
    }

    public Set<URI> getReferences(URI uri) {
        Set<URI> r = this._references.get(uri);
        if (r == null) {
            r = Collections.emptySet();
        }
        return r;
    }

    public boolean isError() {
        return !this._errors.isEmpty();
    }

    public Set<URI> getReferers(URI uri) {
        Set<URI> r = this._referers.get(uri);
        if (r == null) {
            r = Collections.emptySet();
        }
        return r;
    }

    void addReferer(URI reference, URI referer) {
        Set<URI> x = this._referers.get(reference);
        if (x == null) {
            x = new HashSet<URI>();
            this._referers.put(reference, x);
        }
        x.add(referer);
    }

    public Map<URI, Exception> getErrors() {
        return this._errors;
    }
}

