/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapturingXMLEntityResolver
implements XMLEntityResolver {
    private static final Log __log = LogFactory.getLog(CapturingXMLEntityResolver.class);
    private XMLEntityResolver _resolver;
    private Map<URI, byte[]> _capture;

    public CapturingXMLEntityResolver(Map<URI, byte[]> capture, XMLEntityResolver resolver) {
        this._resolver = resolver;
        this._capture = capture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        byte[] data;
        XMLInputSource src;
        InputStream is;
        if (__log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("resolveEntity: base=");
            buf.append(resourceIdentifier.getBaseSystemId());
            buf.append(", literal=");
            buf.append(resourceIdentifier.getLiteralSystemId());
            buf.append(", expanded=");
            buf.append(resourceIdentifier.getExpandedSystemId());
            buf.append(", ns=");
            buf.append(resourceIdentifier.getNamespace());
            buf.append(", publicId=");
            buf.append(resourceIdentifier.getPublicId());
            __log.debug((Object)buf.toString());
        }
        if ((is = (src = this._resolver.resolveEntity(resourceIdentifier)).getByteStream()) == null) {
            __log.debug((Object)("resolveEntity: stream not available for: " + src));
            throw new IOException("Unable to locate resource for namespace " + resourceIdentifier.getNamespace());
        }
        try {
            data = StreamUtils.read(is);
        }
        finally {
            is.close();
        }
        try {
            String identifier = null;
            identifier = resourceIdentifier.getNamespace() == null ? resourceIdentifier.getLiteralSystemId() : resourceIdentifier.getNamespace();
            URI systemId = new URI(FileUtils.encodePath(identifier));
            __log.debug((Object)("Captured: " + systemId));
            this._capture.put(systemId, data);
        }
        catch (URISyntaxException use) {
            __log.error((Object)("Invalid URI: " + resourceIdentifier.getLiteralSystemId()));
            throw new XNIException((Exception)use);
        }
        return this._resolver.resolveEntity(resourceIdentifier);
    }
}

