/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.ObjectPrinter;

public abstract class SimpleMBean
extends StandardMBean
implements MBeanRegistration,
NotificationEmitter {
    private static final Log __log = LogFactory.getLog(SimpleMBean.class);
    protected MBeanServer _mbeanServer;
    protected ObjectName _myName;
    private MBeanNotificationInfo[] _infos = new MBeanNotificationInfo[0];
    private NotificationBroadcasterSupport _nbs = new NotificationBroadcasterSupport();
    private AtomicLong _notificationSequence = new AtomicLong(0L);

    public SimpleMBean(Class intfClass) throws NotCompliantMBeanException {
        super(intfClass);
        this.createMetaData(intfClass);
    }

    private void createMetaData(Class intfClass) {
    }

    @Override
    public void postDeregister() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("postDeregister", new Object[0]));
        }
    }

    @Override
    public void postRegister(Boolean done) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("postRegister", new Object[]{"done", done}));
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("preDeregister", new Object[0]));
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("preRegister", new Object[]{"mbeanServer", mBeanServer, "objectName", objectName}));
        }
        this._mbeanServer = mBeanServer;
        this._myName = objectName;
        return objectName;
    }

    public ObjectName register(MBeanServer server) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("register", new Object[]{"server", server}));
        }
        try {
            server.unregisterMBean(this.getObjectName());
        }
        catch (InstanceNotFoundException ex) {
        }
        catch (MBeanRegistrationException ex) {
            __log.fatal((Object)("Error unregistering mbean: " + this.getObjectName().getCanonicalName()), (Throwable)ex);
        }
        try {
            server.registerMBean(this, this.getObjectName());
        }
        catch (Exception ex) {
            __log.warn((Object)("Exception on register(): " + this.createObjectName()));
        }
        return this.getObjectName();
    }

    public void unregister() {
        this.unregister(this._mbeanServer);
    }

    public void unregister(MBeanServer server) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("unregister", new Object[]{"server", server}));
        }
        try {
            server.unregisterMBean(this.getObjectName());
        }
        catch (Exception ex) {
            __log.warn((Object)("Exception on unregister(): " + this.getObjectName()));
        }
    }

    protected abstract ObjectName createObjectName();

    public static ObjectName createObjectName(String domain, String[] names) {
        StringBuffer buf = new StringBuffer(domain);
        buf.append(':');
        for (int i = 0; i < names.length / 2; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(names[i * 2]);
            buf.append('=');
            buf.append(names[i * 2 + 1].replace('=', '_').replace(',', '_').replace(':', '_'));
        }
        try {
            return new ObjectName(buf.toString());
        }
        catch (Exception ex) {
            String errmsg = "DomainNodeImpl.createObjectName is broken!";
            __log.fatal((Object)errmsg, (Throwable)ex);
            throw new AssertionError((Object)errmsg);
        }
    }

    public ObjectName getObjectName() {
        return this._myName == null ? this.createObjectName() : this._myName;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws IllegalArgumentException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("addNotificationListener", new Object[]{"notificationListener", notificationListener, "notificationFilter", notificationFilter, "handback", o}));
        }
        this._nbs.addNotificationListener(notificationListener, notificationFilter, o);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("removeNotificationListener", new Object[]{"notificationListener", notificationListener}));
        }
        this._nbs.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws ListenerNotFoundException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("removeNotificationListener", new Object[]{"notificationListener", notificationListener, "notificationFilter", notificationFilter, "handback", o}));
        }
        this._nbs.removeNotificationListener(notificationListener, notificationFilter, o);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this._infos;
    }

    protected void addNotificationInfo(MBeanNotificationInfo notInfo) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("send", new Object[]{"addNotificationInfo", notInfo}));
        }
        MBeanNotificationInfo[] replacement = new MBeanNotificationInfo[this._infos.length + 1];
        System.arraycopy(this._infos, 0, replacement, 0, this._infos.length);
        replacement[replacement.length - 1] = notInfo;
        this._infos = replacement;
    }

    protected void send(Notification notification) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("send", new Object[]{"notification", notification}));
        }
        this._nbs.sendNotification(notification);
    }

    protected long nextNotificationSequence() {
        return this._notificationSequence.incrementAndGet();
    }
}

