/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.samples.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.wso2.carbon.integration.framework.TestServerManager;
import org.wso2.carbon.utils.FileManipulator;

public class BRSTestServerManager
extends TestServerManager {
    public static final Log log = LogFactory.getLog(BRSTestServerManager.class);

    @BeforeSuite(timeOut=300000L)
    public String startServer() throws IOException {
        return super.startServer();
    }

    @AfterSuite(timeOut=60000L)
    public void stopServer() throws Exception {
        super.stopServer();
    }

    protected void copyArtifacts(String carbonHome) throws IOException {
        String deploymentDir = this.computeDestDirPath(carbonHome);
        this.copySampleFile(this.computeSourcePath("banking.service/service/target/BankingService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("quotation.service/service/target/GetQuoteService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("callcharging.service/service/target/CallChargingService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("carrental.service/service/target/CarRentalService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("healthcare.service/service/target/HealthCareService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("insurance.service/service/target/InsuranceService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("MIPCalculate.service/service/target/MIPCalculateService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("orderApproval.service/service/target/OrderApprovalService.aar"), deploymentDir);
        this.copySampleFile(this.computeSourcePath("shopping.service/service/target/ShoppingService.aar"), deploymentDir);
    }

    private void copySampleFile(String sourceFilePath, String destDirPath) throws IOException {
        File sourceFile = new File(sourceFilePath);
        File destFile = new File(destDirPath);
        log.info((Object)("Copying " + sourceFile.getAbsolutePath() + " => " + destFile.getAbsolutePath()));
        FileManipulator.copyFileToDir((File)sourceFile, (File)destFile);
    }

    private String computeSourcePath(String fileName) {
        String samplesDir = System.getProperty("samples.dir");
        return samplesDir + File.separator + fileName;
    }

    private String computeDestDirPath(String carbonHome) {
        String deploymentPath = carbonHome + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "ruleservices";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            log.error((Object)("Error while creating the deployment folder : " + deploymentPath));
        }
        return deploymentPath;
    }
}

