/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.receivers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.caching.CachedObject;
import org.wso2.caching.CachingException;

public class CachedMessageReceiver
extends AbstractMessageReceiver {
    Log log = LogFactory.getLog((Class)CachedMessageReceiver.class);

    protected void invokeBusinessLogic(MessageContext messageCtx) throws AxisFault {
    }

    public void receive(MessageContext messageCtx) throws AxisFault {
        MessageContext outMsgContext = MessageContextBuilder.createOutMessageContext((MessageContext)messageCtx);
        if (outMsgContext != null) {
            OperationContext operationContext = outMsgContext.getOperationContext();
            if (operationContext != null) {
                Object cachedObj;
                operationContext.addMessageContext(outMsgContext);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Serving from the cache...");
                }
                if ((cachedObj = operationContext.getProperty("CachedObject")) != null && cachedObj instanceof CachedObject) {
                    try {
                        SOAPMessage smsg;
                        MessageFactory mf = MessageFactory.newInstance();
                        if (messageCtx.isSOAP11()) {
                            smsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(((CachedObject)cachedObj).getResponseEnvelope()));
                        } else {
                            MimeHeaders mimeHeaders = new MimeHeaders();
                            mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
                            mimeHeaders.addHeader("content-type", "application/soap+xml");
                            smsg = mf.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(((CachedObject)cachedObj).getResponseEnvelope()));
                        }
                        if (smsg != null) {
                            SOAPEnvelope omSOAPEnv = SAAJUtil.toOMSOAPEnvelope((Element)smsg.getSOAPPart().getDocumentElement());
                            if (omSOAPEnv.getHeader() == null) {
                                SOAPFactory fac = this.getSOAPFactory(messageCtx);
                                fac.createSOAPHeader(omSOAPEnv);
                            }
                            outMsgContext.setEnvelope(omSOAPEnv);
                        } else {
                            this.handleException("Unable to serve from the cache : Couldn't build the SOAP response from the cached byte stream");
                        }
                    }
                    catch (SOAPException e) {
                        this.handleException("Unable to serve from the cache : Unable to get build the response from the byte stream", e);
                    }
                    catch (IOException e) {
                        this.handleException("Unable to serve from the cache : I/O Error in building the response envelope from the byte stream");
                    }
                    AxisEngine.send((MessageContext)outMsgContext);
                } else {
                    this.handleException("Unable to find the response in the cache");
                }
            } else {
                this.handleException("Unable to serve from the cache : OperationContext not found for processing");
            }
        } else {
            this.handleException("Unable to serve from the cache : Unable to get the out message context");
        }
    }

    private void handleException(String message) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message);
        }
        throw new AxisFault(message, (Throwable)new CachingException(message));
    }

    private void handleException(String message, Throwable cause) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message, cause);
        }
        throw new AxisFault(message, (Throwable)new CachingException(message, cause));
    }
}

