/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachingException;
import org.wso2.caching.policy.CachingPolicyProcessor;

public class CachingModule
implements Module {
    Log log = LogFactory.getLog((Class)CachingModule.class);
    public String moduleName;

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        this.moduleName = module.getName();
        CacheConfiguration cacheConfig = null;
        PolicySubject policySubject = module.getPolicySubject();
        if (policySubject != null) {
            try {
                cacheConfig = CachingPolicyProcessor.processCachingPolicy(policySubject);
            }
            catch (CachingException e) {
                this.handleException("Unable to initialize the caching module : Error in processing caching policy", e);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using the default initializer for the CacheConfiguration");
            }
            cacheConfig = new CacheConfiguration();
        }
        if (cacheConfig != null) {
            configContext.getAxisConfiguration().addParameter("cacheConfiguration", (Object)cacheConfig);
            configContext.setProperty("cacheManager", (Object)new CacheManager());
        } else {
            this.handleException("Unable to engage caching : Error in processing policy");
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (!(axisDescription instanceof AxisService)) {
            return;
        }
        CacheConfiguration cacheConfig = null;
        PolicySubject policySubject = axisDescription.getPolicySubject();
        if (policySubject != null) {
            try {
                cacheConfig = CachingPolicyProcessor.processCachingPolicy(policySubject);
            }
            catch (CachingException e) {
                this.handleException("Unable to engage the caching module : Error in processing caching policy", e);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using the default initializer for the CacheConfiguration");
            }
            cacheConfig = new CacheConfiguration();
        }
        if (cacheConfig != null) {
            axisDescription.addParameter("cacheConfiguration", (Object)cacheConfig);
        } else {
            this.handleException("Unable to engage caching : Error in processing policy");
        }
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        configurationContext.removeProperty("cacheManager");
    }

    private void handleException(String message, Throwable cause) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message, cause);
        }
        throw new AxisFault(message, cause);
    }

    private void handleException(String message) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message);
        }
        throw new AxisFault(message);
    }
}

