/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachedObject;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DigestGenerator;
import org.wso2.caching.handlers.CachingHandler;

public class CachingInHandler
extends CachingHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block21: {
            block22: {
                block23: {
                    OperationContext opCtx;
                    CacheManager cacheManager;
                    String requestHash;
                    ConfigurationContext cfgCtx;
                    CacheConfiguration chCfg;
                    block24: {
                        AxisService axisService;
                        block26: {
                            CachedObject cachedObj;
                            block25: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Starting the execution of the CachingInHandler");
                                }
                                chCfg = null;
                                Parameter ccfgParam = msgContext.getAxisMessage().getParameter("cacheConfiguration");
                                if (ccfgParam != null && ccfgParam.getValue() instanceof CacheConfiguration) {
                                    chCfg = (CacheConfiguration)ccfgParam.getValue();
                                } else {
                                    this.handleException("Unable to perform caching : Could not find the CacheConfiguration");
                                }
                                cfgCtx = msgContext.getConfigurationContext();
                                if (cfgCtx == null) break block22;
                                requestHash = null;
                                try {
                                    DigestGenerator digestGenerator = chCfg.getDigestGenerator();
                                    if (digestGenerator != null) {
                                        requestHash = digestGenerator.getDigest(msgContext);
                                    } else {
                                        this.handleException("Unable to retrieve the DigestGenerator from the CacheManager");
                                    }
                                }
                                catch (CachingException ce) {
                                    this.handleException("Unable to perform caching : Error in generating the request hash");
                                }
                                Object cmObj = cfgCtx.getPropertyNonReplicable("cacheManager");
                                if (cmObj != null && cmObj instanceof CacheManager) {
                                    cacheManager = (CacheManager)cmObj;
                                } else {
                                    ConfigurationContext configurationContext = cfgCtx;
                                    synchronized (configurationContext) {
                                        cmObj = cfgCtx.getPropertyNonReplicable("cacheManager");
                                        if (cmObj != null && cmObj instanceof CacheManager) {
                                            cacheManager = (CacheManager)cmObj;
                                        } else {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)"Creating/recreating the CacheManager object");
                                            }
                                            cacheManager = new CacheManager();
                                            cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                                        }
                                    }
                                }
                                opCtx = msgContext.getOperationContext();
                                if (opCtx == null) break block23;
                                if (!msgContext.isServerSide()) break block21;
                                opCtx.setProperty("requestHash", (Object)requestHash);
                                if (!cacheManager.containsKey(requestHash) || cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx) == null) break block24;
                                cachedObj = cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx);
                                if (cachedObj.isExpired() || cachedObj.getResponseEnvelope() == null) break block25;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Cache-hit for message ID : " + msgContext.getMessageID()));
                                }
                                opCtx.setProperty("CachedObject", (Object)cachedObj);
                                axisService = msgContext.getAxisService();
                                if (axisService == null) break block21;
                                break block26;
                            }
                            cachedObj.expire();
                            cachedObj.setTimeout(chCfg.getTimeout());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Existing cached response has expired. Reset cache element");
                            }
                            opCtx.setProperty("CachedObject", null);
                            cacheManager.addResponseWithKey(requestHash, cachedObj, (AbstractContext)cfgCtx);
                            cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                            cfgCtx.flush();
                            return Handler.InvocationResponse.CONTINUE;
                        }
                        AxisOperation cachedOperation = axisService.getOperation(CachingConstants.CACHED_OPERATION_QNAME);
                        if (cachedOperation != null) {
                            cachedOperation.setControlOperation(true);
                            msgContext.setAxisOperation(cachedOperation);
                            break block21;
                        } else {
                            this.handleException("Unable to perform caching : Could not find the cached operation");
                        }
                        break block21;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"There are no cached responses for the request.");
                    }
                    CachedObject cachedObj = new CachedObject();
                    cachedObj.setRequestHash(requestHash);
                    cachedObj.setTimeout(chCfg.getTimeout());
                    System.out.println(chCfg.getTimeout());
                    cacheManager.addResponseWithKey(requestHash, cachedObj, (AbstractContext)cfgCtx);
                    opCtx.setProperty("CachedObject", null);
                    return Handler.InvocationResponse.CONTINUE;
                }
                this.handleException("Unable to perform caching : OperationContext not found to store cache details");
                break block21;
            }
            this.handleException("Unable to perform caching : ConfigurationContext not found to process cache");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"CachingInHandler execution finished");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

