/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.handlers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachedObject;
import org.wso2.caching.handlers.CachingHandler;
import org.wso2.caching.util.SOAPMessageHelper;

public class CachingOutHandler
extends CachingHandler {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the execution of the CachingOutHandler");
        }
        CacheConfiguration cachCfg = null;
        Parameter chCfgParam = msgContext.getAxisMessage().getParameter("cacheConfiguration");
        if (chCfgParam != null && chCfgParam.getValue() != null && chCfgParam.getValue() instanceof CacheConfiguration) {
            cachCfg = (CacheConfiguration)chCfgParam.getValue();
        } else {
            this.handleException("Unable to process caching : Could not find the CacheConfiguration");
        }
        OperationContext operationCntx = msgContext.getOperationContext();
        if (operationCntx != null) {
            ConfigurationContext cfgCtx = msgContext.getConfigurationContext();
            Object cacheMgrObj = null;
            if (cfgCtx != null) {
                cacheMgrObj = cfgCtx.getProperty("cacheManager");
            } else {
                this.handleException("Unable to store the response in to the cache : ConfigurationContext cannot be found");
            }
            if (cacheMgrObj != null && cacheMgrObj instanceof CacheManager) {
                CacheManager cacheMgr = (CacheManager)cacheMgrObj;
                if (msgContext.isServerSide()) {
                    CachedObject cachedObj;
                    Object cachedRespObj = operationCntx.getProperty("CachedObject");
                    String requestHash = (String)operationCntx.getProperty("requestHash");
                    if (cachedRespObj == null && (cachedObj = cacheMgr.getResponseForKey(requestHash, (AbstractContext)cfgCtx)) != null && cachedObj instanceof CachedObject) {
                        CachedObject cachedObject = cachedObj;
                        SOAPEnvelope envelope = SOAPMessageHelper.cloneSOAPEnvelope(msgContext.getEnvelope());
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        try {
                            envelope.serialize((OutputStream)outStream);
                            cachedObject.setResponseEnvelope(outStream.toByteArray());
                            if (cachedObject.getTimeout() > 0L) {
                                cachedObject.setExpireTimeMillis(System.currentTimeMillis() + cachedObject.getTimeout());
                            }
                        }
                        catch (XMLStreamException e) {
                            this.handleException("Unable to store the cached response : Error in serializing the response", e);
                        }
                        cacheMgr.addResponseWithKey(requestHash, cachedObject, (AbstractContext)cfgCtx);
                        cfgCtx.flush();
                    }
                }
            } else {
                this.handleException("Unable to store the cached response : Unable to find the CacheManager object");
            }
        } else {
            this.handleException("Unable to store the cached response : OperationContext not found for the processing");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

