/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.service;

import java.util.Collection;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.caching.CachingComponentException;
import org.wso2.carbon.caching.CachingConfigData;
import org.wso2.carbon.caching.CachingPolicyUtils;
import org.wso2.registry.Association;
import org.wso2.registry.Registry;
import org.wso2.registry.Resource;
import org.wso2.registry.exceptions.RegistryException;

public class CachingConfigAdminService {
    private static final Log log = LogFactory.getLog(CachingConfigAdminService.class);
    private Registry registry = null;
    private AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
    private CachingPolicyUtils cachingPolicyUtils;
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String ADMIN_SERICE_PARAM_NAME = "adminService";

    public CachingConfigAdminService() {
        this.registry = (Registry)this.axisConfig.getParameterValue("WSO2Registry");
        this.cachingPolicyUtils = new CachingPolicyUtils(this.registry);
    }

    public void enableCaching(String serviceName, CachingConfigData confData) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabling caching for the service: " + serviceName));
        }
        AxisService service = this.retrieveAxisService(serviceName);
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        String servicePath = "/carbon/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
        try {
            Association[] associations = this.registry.getAssociations(servicePath, "engaged.modules");
            boolean associationExist = false;
            for (Association association : associations) {
                if (!association.getDestinationPath().equals(this.getModuleResourcePath(cachingModule))) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.registry.addAssociation(servicePath, this.getModuleResourcePath(cachingModule), "engaged.modules");
            }
        }
        catch (RegistryException e) {
            throw new CachingComponentException("errorEngagingModuleAtRegistry", e, log);
        }
        Policy policy = confData.toPolicy();
        PolicySubject policySubject = service.getPolicySubject();
        Collection policyComponents = policySubject.getAttachedPolicyComponents();
        if (policyComponents == null) {
            policySubject.attachPolicy(policy);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Used the new policy configuration as no existing policy components were found");
            }
        } else {
            Policy[] arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents);
            if (arr == null) {
                policySubject.attachPolicy(policy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Used the new policy configuration as no existing caching assertion was found");
                }
            } else {
                this.cachingPolicyUtils.updateCachingAssertion(arr[0], confData);
                policySubject.updatePolicy(arr[1]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The existing caching policy is updated with the new configuration data");
                }
            }
        }
        try {
            this.cachingPolicyUtils.persistPoliciesToService(policy, servicePath, 6);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caching policy is saved in the registry");
            }
        }
        catch (Exception e) {
            throw new CachingComponentException("errorSavingPolicy", e, log);
        }
        try {
            service.engageModule(cachingModule);
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorEngagingModuleToService", new String[]{serviceName}, af, log);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaged caching for the Axis service: " + serviceName));
        }
    }

    public void globallyEngageCaching(CachingConfigData confData) throws AxisFault, CachingComponentException {
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        String resourcePath = this.getModuleResourcePath(cachingModule);
        try {
            String globalPath = resourcePath + "/global";
            if (this.registry.resourceExists(globalPath)) {
                Resource resource = this.registry.get(globalPath);
                if (!Boolean.parseBoolean(resource.getProperty(GLOBALLY_ENGAGED_PARAM_NAME))) {
                    resource.removeProperty(GLOBALLY_ENGAGED_PARAM_NAME);
                    resource.addProperty(GLOBALLY_ENGAGED_PARAM_NAME, "true");
                    this.registry.put(globalPath, resource);
                }
            } else {
                Resource globalResource = this.registry.newResource();
                globalResource.addProperty(GLOBALLY_ENGAGED_PARAM_NAME, "true");
                this.registry.put(globalPath, globalResource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured in globally engaging caching at registry", (Throwable)e);
            throw new CachingComponentException("errorEngagingModuleAtRegistry", log);
        }
        Policy policy = confData.toPolicy();
        PolicySubject policySubject = cachingModule.getPolicySubject();
        Collection policyComponents = policySubject.getAttachedPolicyComponents();
        if (policyComponents == null) {
            policySubject.attachPolicy(policy);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Used the new policy configuration as no existing policy components were found");
            }
        } else {
            Policy[] arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents);
            if (arr == null) {
                policySubject.attachPolicy(policy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Used the new policy configuration as no existing caching assertion was found");
                }
            } else {
                this.cachingPolicyUtils.updateCachingAssertion(arr[0], confData);
                policySubject.updatePolicy(arr[1]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The existing caching policy is updated with the new configuration data");
                }
            }
        }
        try {
            this.cachingPolicyUtils.persistPoliciesToService(policy, resourcePath, 6);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caching policy is saved in the registry");
            }
        }
        catch (Exception e) {
            throw new CachingComponentException("errorSavingPolicy", e, log);
        }
        cachingModule.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)"true"));
        for (AxisService service : this.axisConfig.getServices().values()) {
            String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
            if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim())) continue;
            this.enableCaching(service.getName(), confData);
        }
    }

    public void disableCaching(String serviceName) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling caching for the service: " + serviceName));
        }
        try {
            AxisService service = this.retrieveAxisService(serviceName);
            String servicePath = "/carbon/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
            try {
                AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
                this.registry.removeAssociation(servicePath, this.getModuleResourcePath(cachingModule), "engaged.modules");
                service.disengageModule(cachingModule);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Disengaged caching for the Axis service: " + serviceName));
                }
            }
            catch (RegistryException e) {
                throw new CachingComponentException("errorDisablingAtRegistry", e, log);
            }
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorDisablingCaching", new String[]{serviceName}, af, log);
        }
    }

    public void disengageGlobalCaching() throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disengaging globally engaged caching");
        }
        try {
            Parameter param;
            Resource resource;
            AxisModule module = this.axisConfig.getModule("wso2caching");
            String resourcePath = this.getModuleResourcePath(module);
            String globalPath = resourcePath + "/global";
            if (this.registry.resourceExists(globalPath) && Boolean.parseBoolean((resource = this.registry.get(globalPath)).getProperty(GLOBALLY_ENGAGED_PARAM_NAME))) {
                resource.removeProperty(GLOBALLY_ENGAGED_PARAM_NAME);
                resource.addProperty(GLOBALLY_ENGAGED_PARAM_NAME, "false");
                this.registry.put(globalPath, resource);
            }
            if ((param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME)) != null) {
                module.removeParameter(module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME));
            }
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim())) continue;
                service.disengageModule(module);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured while removing global caching from registry", (Throwable)e);
            throw new CachingComponentException("errorDisablingAtRegistry", log);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)axisFault);
            throw new CachingComponentException("errorDisablingCaching", log);
        }
    }

    public CachingConfigData getCachingPolicyForService(String serviceName) throws CachingComponentException {
        AxisService service = this.retrieveAxisService(serviceName);
        Collection policyComponents = service.getPolicySubject().getAttachedPolicyComponents();
        return this.getCachingConfig(policyComponents);
    }

    public CachingConfigData getGlobalCachingPolicy() throws CachingComponentException {
        AxisModule module = this.axisConfig.getModule("wso2caching");
        Collection policyComponents = module.getPolicySubject().getAttachedPolicyComponents();
        return this.getCachingConfig(policyComponents);
    }

    private CachingConfigData getCachingConfig(Collection policyComponents) {
        Policy[] arr;
        if (policyComponents != null && (arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returns the configuration data generated from the exisiting caching policy");
            }
            return this.cachingPolicyUtils.generateConfigurationFromPolicy(arr[0]);
        }
        CachingConfigData confData = new CachingConfigData();
        confData.setXmlIdentifier("org.wso2.caching.digest.DOMHASHGenerator");
        confData.setExpTime(60000L);
        confData.setMaxCacheSize(1000);
        confData.setMaxMsgSize(1000);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returns the default configuration data as no caching policy was found");
        }
        return confData;
    }

    public boolean isCachingEnabled(String serviceName) throws CachingComponentException {
        AxisService service = this.retrieveAxisService(serviceName);
        AxisModule module = this.axisConfig.getModule("wso2caching");
        return service.isEngaged(module);
    }

    public boolean isCachingGloballyEnabled() throws CachingComponentException {
        String globallyEngaged;
        AxisModule module = this.axisConfig.getModule("wso2caching");
        Parameter param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
        if (param != null && (globallyEngaged = (String)param.getValue()) != null && globallyEngaged.length() != 0) {
            return Boolean.parseBoolean(globallyEngaged.trim());
        }
        return false;
    }

    private AxisService retrieveAxisService(String serviceName) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Axis service: " + serviceName));
        }
        AxisService axisService = null;
        try {
            axisService = this.axisConfig.getService(serviceName);
            if (axisService == null) {
                throw new CachingComponentException("noSuchService", new String[]{serviceName}, log);
            }
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorRetrievingService", new String[]{serviceName}, af, log);
        }
        return axisService;
    }

    private String getModuleResourcePath(AxisModule axisModule) {
        String moduleName = axisModule.getName();
        String moduleVersion = axisModule.getVersion();
        if (moduleVersion == null || moduleVersion.length() == 0) {
            moduleVersion = "SNAPSHOT";
        }
        return "/carbon/modules/" + moduleName + "/" + moduleVersion;
    }
}

