/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.dashboard.service;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;

public class DashboardService {
    private Queue<String> stockPriceQueue = new ConcurrentLinkedQueue<String>();

    public String getStockQuote() {
        String stockQuote = this.stockPriceQueue.poll();
        return stockQuote != null ? stockQuote : "";
    }

    public void log(OMElement omElement) {
        System.out.println("Event received : " + omElement.toString());
    }

    public void addStockQuote(OMElement stockQuote) {
        try {
            AXIOMXPath symbolXPath = new AXIOMXPath("//stockQuoteEvent/stockSymbol");
            AXIOMXPath priceXPath = new AXIOMXPath("//stockQuoteEvent/stockPrice");
            String symbol = ((OMElement)symbolXPath.selectSingleNode((Object)stockQuote)).getText();
            String price = ((OMElement)priceXPath.selectSingleNode((Object)stockQuote)).getText();
            this.stockPriceQueue.offer(symbol + ":" + price);
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
    }
}

