/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.geo.geoeventfuser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.extension.geo.geoeventfuser.ExecutionPlansCount;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class FuseEvents
extends WindowProcessor {
    private String variable = "";
    private int variablePosition = 0;
    private HashMap<String, ArrayList<StreamEvent>> eventsBuffer = null;
    private static final Log log = LogFactory.getLog(FuseEvents.class);

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to geo:fuseEvents(eventId) function, required 1, but found " + attributeExpressionExecutors.length);
        }
        this.variable = ((VariableExpressionExecutor)attributeExpressionExecutors[0]).getAttribute().getName();
        this.eventsBuffer = new HashMap();
        this.variablePosition = this.inputDefinition.getAttributePosition(this.variable);
    }

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        while (streamEventChunk.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
            String eventId = (String)streamEvent.getOutputData()[this.variablePosition];
            if (this.eventsBuffer.containsKey(eventId)) {
                this.eventsBuffer.get(eventId).add(streamEvent);
                if (this.eventsBuffer.get(eventId).size() == this.getDeployedExecutionPlansCount().intValue()) {
                    this.fuseEvent(streamEvent);
                    this.eventsBuffer.remove(eventId);
                    continue;
                }
                streamEventChunk.remove();
                continue;
            }
            if (this.getDeployedExecutionPlansCount().equals(1)) {
                nextProcessor.process(streamEventChunk);
                continue;
            }
            ArrayList<StreamEvent> buffer = new ArrayList<StreamEvent>();
            buffer.add(streamEvent);
            this.eventsBuffer.put(eventId, buffer);
            streamEventChunk.remove();
        }
        nextProcessor.process(streamEventChunk);
    }

    public Integer getDeployedExecutionPlansCount() {
        return ExecutionPlansCount.getNumberOfExecutionPlans();
    }

    public void fuseEvent(StreamEvent event) {
        String[] statesArray = new String[]{"OFFLINE", "NORMAL", "WARNING", "ALERTED"};
        List<String> states = Arrays.asList(statesArray);
        Object[] data = event.getOutputData();
        String finalState = "";
        String information = "";
        String eventId = (String)event.getOutputData()[this.variablePosition];
        ArrayList<StreamEvent> receivedEvents = this.eventsBuffer.get(eventId);
        String alertStrings = "";
        String warningStrings = "";
        Integer currentStateIndex = -1;
        for (StreamEvent receivedEvent : receivedEvents) {
            String thisState = (String)receivedEvent.getOutputData()[8];
            Integer thisStateIndex = states.indexOf(thisState);
            if (thisStateIndex > currentStateIndex) {
                finalState = thisState;
                currentStateIndex = thisStateIndex;
            }
            if (thisState.equals("ALERTED")) {
                alertStrings = alertStrings + "," + receivedEvent.getOutputData()[9];
                continue;
            }
            if (!thisState.equals("WARNING")) continue;
            warningStrings = warningStrings + "," + receivedEvent.getOutputData()[9];
        }
        if (finalState.equals("NORMAL")) {
            information = "Normal driving pattern";
        } else {
            if (!alertStrings.isEmpty()) {
                information = "Alerts: " + alertStrings;
            }
            if (!warningStrings.isEmpty()) {
                information = information + " | Warnings: " + warningStrings;
            }
        }
        Object[] dataOut = new Object[]{data[0], Double.parseDouble(data[1].toString()), Double.parseDouble(data[2].toString()), Long.parseLong(data[3].toString()), data[4], Float.valueOf(Float.parseFloat(data[5].toString())), Float.valueOf(Float.parseFloat(data[6].toString())), eventId, finalState, information};
        event.setOutputData(dataOut);
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{this.eventsBuffer};
    }

    public void restoreState(Object[] state) {
    }
}

