/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.http;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.log4j.Logger;
import org.wso2.carbon.sample.http.HttpUtil;

public class Http {
    private static Logger log = Logger.getLogger(Http.class);
    private static List<String> messagesList = new ArrayList<String>();
    private static BufferedReader bufferedReader = null;
    private static StringBuffer message = new StringBuffer("");
    private static final String asterixLine = "*****";

    public static void main(String[] args) {
        System.out.println("Starting WSO2 Http Client");
        HttpUtil.setTrustStoreParams();
        String url = args[0];
        String username = args[1];
        String password = args[2];
        String sampleNumber = args[3];
        String filePath = args[4];
        SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
        try {
            HttpPost method = new HttpPost(url);
            filePath = HttpUtil.getMessageFilePath(sampleNumber, filePath, url);
            Http.readMsg(filePath);
            for (String message : messagesList) {
                StringEntity entity = new StringEntity(message);
                System.out.println("Sending message:");
                System.out.println(message);
                System.out.println();
                method.setEntity((HttpEntity)entity);
                if (url.startsWith("https")) {
                    Http.processAuthentication(method, username, password);
                }
                httpClient.execute((HttpUriRequest)method).getEntity().getContent().close();
            }
            Thread.sleep(500L);
        }
        catch (Throwable t) {
            log.error((Object)"Error when sending the messages", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMsg(String filePath) {
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals(asterixLine.trim()) && !"".equals(message.toString().trim())) {
                    messagesList.add(message.toString());
                    message = new StringBuffer("");
                    continue;
                }
                message = message.append(String.format("\n%s", line));
            }
            if (!"".equals(message.toString().trim())) {
                messagesList.add(message.toString());
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when closing the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void processAuthentication(HttpPost method, String username, String password) {
        if (username != null && username.trim().length() > 0) {
            method.setHeader("Authorization", "Basic " + Base64.encode((byte[])(username + ":" + password).getBytes()));
        }
    }
}

