/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.http.performance;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;

public class Http
implements Runnable {
    private static Log log = LogFactory.getLog(Http.class);
    static String url;
    static String username;
    static String password;
    static long noOfEvents;
    long count = 0L;
    static int elapsedCount;
    static int noOfPublishers;

    public static void main(String[] args) {
        log.info((Object)"Starting WSO2 Http Client");
        url = args[0];
        username = args[1];
        password = args[2];
        try {
            noOfEvents = Long.parseLong(args[3]);
            elapsedCount = Integer.parseInt(args[4]);
            noOfPublishers = Integer.parseInt(args[5]);
            ExecutorService executor = Executors.newFixedThreadPool(noOfPublishers);
            for (int i = 0; i < noOfPublishers; ++i) {
                Http publisher = new Http();
                executor.execute(publisher);
            }
            executor.shutdown();
        }
        catch (NumberFormatException e) {
            log.error((Object)"Entered value for no of events is invalid. Please enter an integer", (Throwable)e);
        }
    }

    private static void processAuthentication(HttpPost method, String username, String password) {
        if (username != null && username.trim().length() > 0) {
            method.setHeader("Authorization", "Basic " + Base64.encode((byte[])(username + ":" + password).getBytes()));
        }
    }

    private static JsonObject getRandomEvent(long count) {
        JsonObject event = new JsonObject();
        JsonObject metaData = new JsonObject();
        JsonObject correlationData = new JsonObject();
        JsonObject payLoadData = new JsonObject();
        metaData.addProperty("timestamp", (Number)System.currentTimeMillis());
        metaData.addProperty("isPowerSaverEnabled", Boolean.valueOf(false));
        metaData.addProperty("sensorId", (Number)count);
        metaData.addProperty("sensorName", "temperature");
        correlationData.addProperty("longitude", (Number)2332.424);
        correlationData.addProperty("latitude", (Number)2323.23232);
        payLoadData.addProperty("humidity", (Number)Float.valueOf(2.3f));
        payLoadData.addProperty("sensorValue", (Number)23423.234);
        event.add("metaData", (JsonElement)metaData);
        event.add("correlationData", (JsonElement)correlationData);
        event.add("payloadData", (JsonElement)payLoadData);
        return event;
    }

    @Override
    public void run() {
        SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
        try {
            HttpPost method = new HttpPost(url);
            log.info((Object)"Sending messages..");
            long lastTime = System.currentTimeMillis();
            DecimalFormat decimalFormat = new DecimalFormat("#");
            while (this.count < noOfEvents) {
                ++this.count;
                String temp = "{\"event\": " + Http.getRandomEvent(this.count).toString() + "}";
                StringEntity entity = new StringEntity(temp);
                method.setEntity((HttpEntity)entity);
                if (url.startsWith("https")) {
                    Http.processAuthentication(method, username, password);
                }
                httpClient.execute((HttpUriRequest)method).getEntity().getContent().close();
                if (this.count % (long)elapsedCount != 0L) continue;
                long currentTime = System.currentTimeMillis();
                long elapsedTime = currentTime - lastTime;
                double throughputPerSecond = (double)elapsedCount / (double)elapsedTime * 1000.0;
                lastTime = currentTime;
                log.info((Object)("Sent " + elapsedCount + " sensor events in " + elapsedTime + " milliseconds with total throughput of " + decimalFormat.format(throughputPerSecond) + " events per second."));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error when sending the messages", t);
        }
    }
}

