/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.consumer;

import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIContext {
    private static Log log = LogFactory.getLog(JNDIContext.class);
    private InitialContext initContext = null;
    private TopicConnectionFactory topicConnectionFactory = null;
    private QueueConnectionFactory queueConnectionFactory = null;
    public static JNDIContext instance = null;

    private JNDIContext() {
        this.createInitialContext();
        this.createTopicConnectionFactory();
        this.createQueueConnectionFactory();
    }

    public InitialContext getInitContext() {
        return this.initContext;
    }

    public TopicConnectionFactory getTopicConnectionFactory() {
        return this.topicConnectionFactory;
    }

    public QueueConnectionFactory getQueueConnectionFactory() {
        return this.queueConnectionFactory;
    }

    public static JNDIContext getInstance() {
        if (instance == null) {
            instance = new JNDIContext();
        }
        return instance;
    }

    private void createTopicConnectionFactory() {
        try {
            this.topicConnectionFactory = (TopicConnectionFactory)this.initContext.lookup("ConnectionFactory");
        }
        catch (NamingException e) {
            log.info((Object)("Can not create topic connection factory." + e));
        }
    }

    private void createQueueConnectionFactory() {
        try {
            this.queueConnectionFactory = (QueueConnectionFactory)this.initContext.lookup("ConnectionFactory");
        }
        catch (NamingException e) {
            log.info((Object)("Can not create queue connection factory." + e));
        }
    }

    private void createInitialContext() {
        try {
            this.initContext = new InitialContext();
        }
        catch (NamingException e) {
            log.info((Object)("Can not create initial context with given parameters." + e));
        }
    }
}

