/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.kafka;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.sample.kafka.KafkaUtil;

public class Kafka {
    private static Log log = LogFactory.getLog(Kafka.class);
    private static List<String> messagesList = new ArrayList<String>();
    private static BufferedReader bufferedReader = null;
    private static StringBuffer message = new StringBuffer("");
    private static final String asteriskLine = "*****";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log.info((Object)("Command line arguments passed: " + Arrays.deepToString(args)));
        log.info((Object)"Starting Kafka Client");
        String url = args[0];
        String topic = args[1];
        String filePath = args[2];
        String sampleNumber = args[3];
        Properties props = new Properties();
        props.put("metadata.broker.list", url);
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        ProducerConfig config = new ProducerConfig(props);
        try (Producer producer = new Producer(config);){
            filePath = KafkaUtil.getEventFilePath(sampleNumber, topic, filePath);
            Kafka.readMsg(filePath);
            for (String message : messagesList) {
                System.out.println("Sending message:");
                System.out.println(message);
                KeyedMessage data = new KeyedMessage(topic, (Object)message);
                producer.send(data);
            }
            Thread.sleep(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMsg(String filePath) {
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals(asteriskLine.trim()) && !"".equals(message.toString().trim())) {
                    messagesList.add(message.toString());
                    message = new StringBuffer("");
                    continue;
                }
                message = message.append(String.format("\n%s", line));
            }
            if (!"".equals(message.toString().trim())) {
                messagesList.add(message.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when closing the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

