/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.kafka.performance;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import org.wso2.carbon.sample.kafka.performance.ConsumerTest;

public class KafkaConsumer {
    private final ConsumerConnector consumer;
    private final String topic;
    private ExecutorService executor;

    public KafkaConsumer(String zookeeperUrl, String groupId, String topic) {
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)KafkaConsumer.createConsumerConfig(zookeeperUrl, groupId));
        this.topic = topic;
    }

    public static void main(String[] args) {
        String zookeeperUrl = args[0];
        String groupId = args[1];
        String topic = args[2];
        int noOfConsumers = Integer.parseInt(args[3]);
        KafkaConsumer kafkaConsumer = new KafkaConsumer(zookeeperUrl, groupId, topic);
        kafkaConsumer.start(noOfConsumers);
    }

    public void start(int numOfConsumers) {
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(this.topic, new Integer(numOfConsumers));
        Map consumerMap = this.consumer.createMessageStreams(topicCountMap);
        List streams = (List)consumerMap.get(this.topic);
        this.executor = Executors.newFixedThreadPool(numOfConsumers);
        for (KafkaStream stream : streams) {
            this.executor.submit(new ConsumerTest(stream));
        }
    }

    private static ConsumerConfig createConsumerConfig(String zookeeperUrl, String groupId) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zookeeperUrl);
        props.put("group.id", groupId);
        props.put("zookeeper.session.timeout.ms", "6000");
        props.put("zookeeper.sync.time.ms", "2000");
        props.put("auto.commit.interval.ms", "1000");
        return new ConsumerConfig(props);
    }
}

