/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.kpidefinition;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.Random;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.thrift.DataPublisher;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.sample.kpidefinition.KeyStoreUtil;

public class KPIAgent {
    private static Logger logger = Logger.getLogger(KPIAgent.class);
    public static final String PHONE_RETAIL_STREAM = "org.wso2.sample.phone.retail.store.kpi";
    public static final String VERSION = "1.0.0";
    public static final String[] phoneModels = new String[]{"Nokia", "Apple", "Samsung", "Sony-Ericson", "LG"};
    public static final String[] users = new String[]{"James", "Mary", "John", "Peter", "Harry", "Tom", "Paul"};
    public static final int[] quantity = new int[]{2, 5, 3, 4, 1};
    public static final int[] price = new int[]{50000, 55000, 90000, 80000, 70000};

    public static void main(String[] args) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException, MalformedURLException, javax.security.sasl.AuthenticationException, NoStreamDefinitionExistException, TransportException, SocketException, AuthenticationException {
        System.out.println("Starting Phone Retail Shop KPI Agent");
        KeyStoreUtil.setTrustStoreParams();
        String host = args[0];
        String port = args[1];
        String username = args[2];
        String password = args[3];
        int events = Integer.parseInt(args[4]);
        DataPublisher dataPublisher = new DataPublisher("tcp://" + host + ":" + port, username, password);
        String streamId = null;
        try {
            streamId = dataPublisher.findStream(PHONE_RETAIL_STREAM, VERSION);
            System.out.println("Stream already defined");
        }
        catch (NoStreamDefinitionExistException e) {
            streamId = dataPublisher.defineStream("{  'name':'org.wso2.sample.phone.retail.store.kpi',  'version':'1.0.0',  'nickName': 'Phone_Retail_Shop',  'description': 'Phone Sales',  'metaData':[          {'name':'clientType','type':'STRING'}  ],  'payloadData':[          {'name':'brand','type':'STRING'},          {'name':'quantity','type':'INT'},          {'name':'total','type':'INT'},          {'name':'user','type':'STRING'}  ]}");
        }
        if (!streamId.isEmpty()) {
            System.out.println("Stream ID: " + streamId);
            for (int i = 0; i < events; ++i) {
                KPIAgent.publishEvents(dataPublisher, streamId, i);
                System.out.println("Events published : " + (i + 1));
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            dataPublisher.stop();
        }
    }

    private static void publishEvents(DataPublisher dataPublisher, String streamId, int i) throws AgentException {
        int quantity = KPIAgent.getRandomQuantity();
        Event eventOne = new Event(streamId, System.currentTimeMillis(), new Object[]{"external"}, null, new Object[]{KPIAgent.getRandomProduct(), quantity, quantity * KPIAgent.getRandomPrice(), KPIAgent.getRandomUser()});
        dataPublisher.publish(eventOne);
    }

    private static String getRandomProduct() {
        return phoneModels[KPIAgent.getRandomId(5)];
    }

    private static String getRandomUser() {
        return users[KPIAgent.getRandomId(7)];
    }

    private static int getRandomQuantity() {
        return quantity[KPIAgent.getRandomId(5)];
    }

    private static int getRandomPrice() {
        return price[KPIAgent.getRandomId(5)];
    }

    private static int getRandomId(int i) {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(i);
    }
}

