/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.mqttclient;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.wso2.carbon.sample.mqttclient.MQTTClientUtil;

public class MQTTClient {
    private static Logger log = Logger.getLogger(MQTTClient.class);
    private static List<String> messagesList = new ArrayList<String>();
    private static BufferedReader bufferedReader = null;
    private static StringBuffer message = new StringBuffer("");
    private static final String asterixLine = "*****";
    private static MqttClient mqttClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String url = args[0];
        String topic = args[1];
        String filePath = args[2];
        String sampleNumber = null;
        if (args.length == 4) {
            sampleNumber = args[3];
        }
        System.out.println("Starting MQTT Client");
        MqttConnectOptions connOpt = new MqttConnectOptions();
        connOpt.setCleanSession(true);
        connOpt.setKeepAliveInterval(30);
        try {
            mqttClient = new MqttClient(url, "SIMPLE-MQTT-PUB");
            mqttClient.connect(connOpt);
            try {
                filePath = MQTTClientUtil.getMessageFilePath(sampleNumber, filePath, topic);
                MQTTClient.readMsg(filePath);
                for (String message : messagesList) {
                    System.out.println("Sending message:");
                    System.out.println(message);
                    int pubQoS = 1;
                    MqttMessage mqttMessage = new MqttMessage(message.getBytes());
                    mqttMessage.setQos(pubQoS);
                    mqttClient.publish(topic, mqttMessage);
                }
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                log.error((Object)"Error when sending the messages", t);
            }
            finally {
                if (mqttClient != null) {
                    try {
                        mqttClient.disconnect();
                    }
                    catch (MqttException e) {
                        log.error((Object)"Error while disconnecting the MQTT client", (Throwable)e);
                    }
                }
            }
        }
        catch (MqttException e) {
            log.error((Object)"Error while connecting to MQTT server", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMsg(String filePath) {
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals(asterixLine.trim()) && !"".equals(message.toString().trim())) {
                    messagesList.add(message.toString());
                    message = new StringBuffer("");
                    continue;
                }
                message = message.append(String.format("\n%s", line));
            }
            if (!"".equals(message.toString().trim())) {
                messagesList.add(message.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when closing the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

