/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.mqtt.consumer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttConsumer
implements MqttCallback {
    private static Log log = LogFactory.getLog(MqttConsumer.class);
    private MqttClient myClient;
    private static String url;
    private static String topic;

    public static void main(String[] args) {
        if (args.length != 2) {
            log.error((Object)"Please provide necessary parameters");
            return;
        }
        url = args[0];
        topic = args[1];
        MqttConsumer smc = new MqttConsumer();
        smc.runClient();
    }

    public void connectionLost(Throwable t) {
        log.warn((Object)"Connection lost!");
    }

    public void messageArrived(String s, MqttMessage mqttMessage) throws Exception {
        System.out.println("Received Message -------------------------------------------------");
        System.out.println("| Topic:" + s);
        System.out.println("| Message: " + new String(mqttMessage.getPayload()));
        System.out.println("------------------------------------------------------------------");
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void runClient() {
        MqttConnectOptions connOpt = new MqttConnectOptions();
        connOpt.setCleanSession(true);
        connOpt.setKeepAliveInterval(30);
        try {
            this.myClient = new MqttClient(url, "SIMPLE-MQTT-SUB1");
            this.myClient.setCallback((MqttCallback)this);
            this.myClient.connect(connOpt);
            log.info((Object)("Connected to " + url));
        }
        catch (MqttException e) {
            log.error((Object)"Exception when connecting to MQTT Server", (Throwable)e);
        }
        try {
            int subQoS = 0;
            this.myClient.subscribe(topic, subQoS);
        }
        catch (Exception e) {
            log.error((Object)"Exception when initiating the subscription", (Throwable)e);
        }
        try {
            Thread.sleep(5000000L);
            this.myClient.disconnect();
        }
        catch (MqttException e) {
            log.error((Object)"Exception when disconnecting MQTT connection", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Exception when listening for events", (Throwable)e);
        }
    }
}

