/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.purchaseinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.wso2.carbon.sample.purchaseinfo.JNDIContext;

public class MapPurchaseInfoClient {
    private static final List<Map<String, Object>> jsonMsgs = new ArrayList<Map<String, Object>>();
    private static TopicConnectionFactory topicConnectionFactory;

    public static void main(String[] args) throws InterruptedException, NamingException {
        topicConnectionFactory = JNDIContext.getInstance().getTopicConnectionFactory();
        MapPurchaseInfoClient publisher = new MapPurchaseInfoClient();
        String topicName = args[0];
        Thread.sleep(2000L);
        publisher.publish(topicName, jsonMsgs);
        System.out.println("All Order Messages sent");
    }

    public void publish(String topicName, List<Map<String, Object>> messages) {
        TopicConnection topicConnection = null;
        try {
            topicConnection = topicConnectionFactory.createTopicConnection();
            topicConnection.start();
        }
        catch (JMSException e) {
            System.out.println("Can not create topic connection." + (Object)((Object)e));
            return;
        }
        TopicSession session = null;
        try {
            session = topicConnection.createTopicSession(false, 1);
            Topic topic = session.createTopic(topicName);
            MessageProducer producer = session.createProducer((Destination)topic);
            System.out.println("Sending Map messages on '" + topicName + "' topic");
            int jsonMsgsLength = messages.size();
            for (int i = 0; i < jsonMsgsLength; ++i) {
                Map<String, Object> message = messages.get(i);
                MapMessage mapMessage = session.createMapMessage();
                for (Map.Entry<String, Object> entry : message.entrySet()) {
                    mapMessage.setObject(entry.getKey(), entry.getValue());
                }
                producer.send((Message)mapMessage);
                System.out.println("Order Message " + (i + 1) + " sent");
            }
            producer.close();
            session.close();
            topicConnection.stop();
            topicConnection.close();
        }
        catch (JMSException e) {
            System.out.println("Can not subscribe." + (Object)((Object)e));
        }
    }

    static {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put("cardId", "1234-3244-2432-4124");
        tempMap.put("amount", 100.0);
        tempMap.put("countryId", "AU");
        jsonMsgs.add(tempMap);
        HashMap<String, Object> tempMap1 = new HashMap<String, Object>();
        tempMap1.put("cardId", "1234-3244-2432-0124");
        tempMap1.put("amount", 600.0);
        tempMap1.put("countryId", "UK");
        jsonMsgs.add(tempMap1);
        HashMap<String, Object> tempMap2 = new HashMap<String, Object>();
        tempMap2.put("cardId", "1234-3244-2432-7124");
        tempMap2.put("amount", 10045.0);
        tempMap2.put("countryId", "AU");
        jsonMsgs.add(tempMap2);
        HashMap<String, Object> tempMap3 = new HashMap<String, Object>();
        tempMap3.put("cardId", "1234-3244-2432-1124");
        tempMap3.put("amount", 70.5);
        tempMap3.put("countryId", "US");
        jsonMsgs.add(tempMap3);
        HashMap<String, Object> tempMap4 = new HashMap<String, Object>();
        tempMap4.put("cardId", "1234-3244-2432-9124");
        tempMap4.put("amount", 35.0);
        tempMap4.put("countryId", "AU");
        jsonMsgs.add(tempMap4);
        HashMap<String, Object> tempMap5 = new HashMap<String, Object>();
        tempMap5.put("cardId", "1234-3244-2432-4124");
        tempMap5.put("amount", 1500.0);
        tempMap5.put("countryId", "UK");
        jsonMsgs.add(tempMap5);
        HashMap<String, Object> tempMap6 = new HashMap<String, Object>();
        tempMap6.put("cardId", "1234-3244-2432-1124");
        tempMap6.put("amount", 1060.0);
        tempMap6.put("countryId", "US");
        jsonMsgs.add(tempMap6);
        topicConnectionFactory = null;
    }
}

