/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.soap;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.log4j.Logger;
import org.wso2.carbon.sample.soap.SoapUtil;

public class Soap {
    private static Logger log = Logger.getLogger(Soap.class);
    private static List<String> messagesList = new ArrayList<String>();
    private static BufferedReader bufferedReader = null;
    private static StringBuffer message = new StringBuffer("");
    private static final String asterixLine = "*****";

    public static void main(String[] args) {
        String url = args[0];
        String sampleNumber = args[1];
        String filePath = args[2];
        log.info((Object)"Starting WSO2 Soap Client");
        try {
            ServiceClient serviceClient = new ServiceClient();
            Options options = new Options();
            options.setTo(new EndpointReference(url));
            serviceClient.setOptions(options);
            if (serviceClient != null) {
                filePath = SoapUtil.getMessageFilePath(sampleNumber, filePath, url);
                Soap.readMsg(filePath);
                try {
                    System.out.println("Starting sending of events...");
                    OMElement omElement1 = AXIOMUtil.stringToOM((String)message.toString());
                    serviceClient.fireAndForget(omElement1);
                    log.info((Object)"Message sent");
                }
                catch (XMLStreamException e) {
                    log.error((Object)("Error occurred when sending message " + message.toString()), (Throwable)e);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error occurred when sending message " + message.toString()), (Throwable)axisFault);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)("Error occurred when connecting to endpoint " + url), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMsg(String filePath) {
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals(asterixLine.trim()) && !"".equals(message.toString().trim())) {
                    messagesList.add(message.toString());
                    message = new StringBuffer("");
                    continue;
                }
                message = message.append(String.format("\n%s", line));
            }
            if (!"".equals(message.toString().trim())) {
                messagesList.add(message.toString());
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when closing the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

