/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.websocket;

import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.component.LifeCycle;

public class WebSocketClient {
    private static Log log = LogFactory.getLog(WebSocketClient.class);
    private WebSocketContainer container;
    private Session session;

    public void connect(String url) {
        block5: {
            URI uri = URI.create(url);
            try {
                this.container = ContainerProvider.getWebSocketContainer();
                this.session = this.container.connectToServer(EventSocketClient.class, uri);
                if (this.session == null) {
                    throw new RuntimeException("Cannot connect to url :" + url);
                }
            }
            catch (Throwable t) {
                log.error((Object)t);
                if (this.container == null || !(this.container instanceof LifeCycle)) break block5;
                try {
                    ((LifeCycle)this.container).stop();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public void stop() {
        if (this.container != null && this.container instanceof LifeCycle) {
            try {
                ((LifeCycle)this.container).stop();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    @ClientEndpoint
    public static class EventSocketClient {
        @OnOpen
        public void onWebSocketConnect(Session sess) {
            log.info((Object)("Client Socket Connected: " + sess));
        }

        @OnMessage
        public void onWebSocketText(String message) {
            log.info((Object)("Client Received TEXT message: " + message));
        }

        @OnClose
        public void onWebSocketClose(CloseReason reason) {
            log.info((Object)("Client Socket Closed: " + reason));
        }

        @OnError
        public void onWebSocketError(Throwable cause) {
            log.error((Object)"Client Socket Error", cause);
        }
    }
}

