/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.websocket;

import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class WebSocketServer {
    private static Log log = LogFactory.getLog(WebSocketServer.class);
    private Server server = null;

    public void start(int port, String host) {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(host);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        try {
            ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
            wscontainer.addEndpoint(EventSocket.class);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketServer.this.server.start();
                        WebSocketServer.this.server.join();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }).start();
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.server = null;
        }
    }

    @ServerEndpoint(value="/events/")
    public static class EventSocket {
        @OnOpen
        public void onWebSocketConnect(Session sess) {
            log.info((Object)("Server Socket Connected: " + sess));
        }

        @OnMessage
        public void onWebSocketText(String message) {
            log.info((Object)("Server Received TEXT message: " + message));
        }

        @OnClose
        public void onWebSocketClose(CloseReason reason) {
            log.info((Object)("Server Socket Closed: " + reason));
        }

        @OnError
        public void onWebSocketError(Throwable cause) {
            log.error((Object)"Server Socket Error", cause);
        }
    }
}

