/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.wso2event;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.sample.wso2event.DataPublisherUtil;

public class Client {
    private static Logger log = Logger.getLogger(Client.class);

    public static void main(String[] args) {
        System.out.println(Arrays.deepToString(args));
        try {
            System.out.println("Starting WSO2 Event Client");
            AgentHolder.setConfigPath((String)DataPublisherUtil.getDataAgentConfigPath());
            DataPublisherUtil.setTrustStoreParams();
            String protocol = args[0];
            String host = args[1];
            String port = args[2];
            String username = args[3];
            String password = args[4];
            String streamId = args[5];
            String sampleNumber = args[6];
            String filePath = args[7];
            int events = Integer.parseInt(args[8]);
            int delay = Integer.parseInt(args[9]);
            Map<String, StreamDefinition> streamDefinitions = DataPublisherUtil.loadStreamDefinitions(sampleNumber);
            if (streamId == null || streamId.length() == 0) {
                throw new Exception("streamId not provided");
            }
            StreamDefinition streamDefinition = streamDefinitions.get(streamId);
            if (streamDefinition == null) {
                throw new Exception("StreamDefinition not available for stream " + streamId);
            }
            log.info((Object)("StreamDefinition used :" + streamDefinition));
            filePath = DataPublisherUtil.getEventFilePath(sampleNumber, streamId, filePath);
            DataPublisher dataPublisher = new DataPublisher(protocol, "tcp://" + host + ":" + port, null, username, password);
            Client.publishEvents(dataPublisher, streamDefinition, filePath, events, delay);
            dataPublisher.shutdownWithAgent();
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishEvents(DataPublisher dataPublisher, StreamDefinition streamDefinition, String filePath, int events, int delay) {
        int metaSize = streamDefinition.getMetaData() == null ? 0 : streamDefinition.getMetaData().size();
        int correlationSize = streamDefinition.getCorrelationData() == null ? 0 : streamDefinition.getCorrelationData().size();
        int payloadSize = streamDefinition.getPayloadData() == null ? 0 : streamDefinition.getPayloadData().size();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null && events != 0) {
                String[] data = line.split(",");
                Object[] meta = null;
                if (metaSize > 0) {
                    meta = new Object[metaSize];
                    List metaData = streamDefinition.getMetaData();
                    for (int i = 0; i < metaData.size(); ++i) {
                        Attribute attribute = (Attribute)metaData.get(i);
                        meta[i] = Client.convertData(data[i], attribute);
                    }
                }
                Object[] correlation = null;
                if (correlationSize > 0) {
                    correlation = new Object[correlationSize];
                    List correlationData = streamDefinition.getCorrelationData();
                    for (int i = 0; i < correlationData.size(); ++i) {
                        Attribute attribute = (Attribute)correlationData.get(i);
                        correlation[i] = Client.convertData(data[metaSize + i], attribute);
                    }
                }
                Object[] payload = null;
                if (payloadSize > 0) {
                    payload = new Object[payloadSize];
                    List payloadData = streamDefinition.getPayloadData();
                    for (int i = 0; i < payloadData.size(); ++i) {
                        Attribute attribute = (Attribute)payloadData.get(i);
                        payload[i] = Client.convertData(data[metaSize + correlationSize + i], attribute);
                    }
                }
                Event event = new Event(streamDefinition.getStreamId(), System.currentTimeMillis(), meta, correlation, payload);
                dataPublisher.publish(event);
                if (delay > 0) {
                    Thread.sleep(delay);
                }
                --events;
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error in reading file " + filePath), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Thread interrupted while sleeping between events", (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static Object convertData(String data, Attribute attribute) {
        switch (attribute.getType()) {
            case INT: {
                return Integer.parseInt(data);
            }
            case LONG: {
                return Long.parseLong(data);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(data));
            }
            case DOUBLE: {
                return Double.parseDouble(data);
            }
            case STRING: {
                return data;
            }
            case BOOL: {
                return Boolean.parseBoolean(data);
            }
        }
        throw new RuntimeException("data:" + data + " is of unsupported type");
    }
}

