/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.wso2event;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;

public class DataPublisherUtil {
    private static Logger log = Logger.getLogger(DataPublisherUtil.class);
    static File securityFile = new File(".." + File.separator + ".." + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security");
    static String configDirectoryPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventstreams";
    static String sampleDirectoryPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "samples" + File.separator + "artifacts" + File.separator + "sampleNumber" + File.separator;
    static String sampleStreamDefinitionsDirectoryPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "samples" + File.separator + "artifacts" + File.separator + "sampleNumber" + File.separator + "eventstreams" + File.separator;
    static String dataAgentConfigPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "repository" + File.separator + "conf" + File.separator + "data-bridge" + File.separator + "data-agent-config.xml";

    public static void setTrustStoreParams() {
        String trustStore = securityFile.getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", trustStore + "" + File.separator + "client-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
    }

    public static void setKeyStoreParams() {
        String keyStore = securityFile.getAbsolutePath();
        System.setProperty("Security.KeyStore.Location", keyStore + "" + File.separator + "wso2carbon.jks");
        System.setProperty("Security.KeyStore.Password", "wso2carbon");
    }

    public static String getDataAgentConfigPath() {
        return new File(dataAgentConfigPath).getAbsolutePath();
    }

    public static String getEventFilePath(String sampleNumber, String streamId, String filePath) throws Exception {
        String resultingFilePath;
        if (sampleNumber != null && sampleNumber.length() == 0) {
            sampleNumber = null;
        }
        if (filePath != null && filePath.length() == 0) {
            filePath = null;
        }
        if (filePath != null && sampleNumber == null) {
            resultingFilePath = filePath;
        } else if (filePath == null && sampleNumber != null) {
            resultingFilePath = sampleDirectoryPath.replace("sampleNumber", sampleNumber) + streamId.replaceAll(":", "_").replaceAll("\\.", "_") + ".csv";
        } else {
            throw new Exception("In sampleNumber:'" + sampleNumber + "' and filePath:'" + filePath + "' one must be null and other not null");
        }
        File file = new File(resultingFilePath);
        if (!file.isFile()) {
            throw new Exception("'" + resultingFilePath + "' is not a file");
        }
        if (!file.exists()) {
            throw new Exception("file '" + resultingFilePath + "' does not exist");
        }
        return resultingFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, StreamDefinition> loadStreamDefinitions(String sampleNumber) {
        String directoryPath = sampleNumber.length() != 0 ? sampleStreamDefinitionsDirectoryPath.replace("sampleNumber", sampleNumber) : configDirectoryPath;
        File directory = new File(directoryPath);
        HashMap<String, StreamDefinition> streamDefinitions = new HashMap<String, StreamDefinition>();
        if (!directory.exists()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " directory not exist"));
            return streamDefinitions;
        }
        if (!directory.isDirectory()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " not a directory"));
            return streamDefinitions;
        }
        File[] defFiles = directory.listFiles();
        if (defFiles != null) {
            for (File fileEntry : defFiles) {
                if (fileEntry.isDirectory()) continue;
                BufferedReader bufferedReader = null;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    String line;
                    bufferedReader = new BufferedReader(new FileReader(fileEntry));
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line).append("\n");
                    }
                    StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)stringBuilder.toString().trim());
                    streamDefinitions.put(streamDefinition.getStreamId(), streamDefinition);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Error in reading file " + fileEntry.getName()), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Error in reading file " + fileEntry.getName()), (Throwable)e);
                }
                catch (MalformedStreamDefinitionException e) {
                    log.error((Object)("Error in converting Stream definition " + e.getMessage()), (Throwable)e);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        return streamDefinitions;
    }
}

