/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.server;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.DataBridge;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.InMemoryStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.receiver.binary.conf.BinaryDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiver;
import org.wso2.carbon.databridge.receiver.thrift.ThriftDataReceiver;
import org.wso2.carbon.sample.server.WSO2EventServerUtil;
import org.wso2.carbon.user.api.UserStoreException;

public class TestWso2EventServer {
    Logger log = Logger.getLogger(TestWso2EventServer.class);
    ThriftDataReceiver thriftDataReceiver;
    BinaryDataReceiver binaryDataReceiver;
    AbstractStreamDefinitionStore streamDefinitionStore = new InMemoryStreamDefinitionStore();
    static final TestWso2EventServer testServer = new TestWso2EventServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws DataBridgeException, StreamDefinitionStoreException {
        testServer.start(args[0], Integer.parseInt(args[1]), args[2], args[3]);
        TestWso2EventServer testWso2EventServer = testServer;
        synchronized (testWso2EventServer) {
            try {
                testServer.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start(String host, int receiverPort, String protocol, String sampleNumber) throws DataBridgeException, StreamDefinitionStoreException {
        WSO2EventServerUtil.setKeyStoreParams();
        DataBridge databridge = new DataBridge(new AuthenticationHandler(){

            public boolean authenticate(String userName, String password) {
                return true;
            }

            public String getTenantDomain(String userName) {
                return "admin";
            }

            public int getTenantId(String s) throws UserStoreException {
                return -1234;
            }

            public void initContext(AgentSession agentSession) {
            }

            public void destroyContext(AgentSession agentSession) {
            }

            public void setThreadLocalContext(AgentSession agentSession) {
            }
        }, this.streamDefinitionStore, WSO2EventServerUtil.getDataBridgeConfigPath());
        for (StreamDefinition streamDefinition : WSO2EventServerUtil.loadStreamDefinitions(sampleNumber)) {
            this.streamDefinitionStore.saveStreamDefinitionToStore(streamDefinition, -1234);
            this.log.info((Object)("StreamDefinition of '" + streamDefinition.getStreamId() + "' added to store"));
        }
        databridge.subscribe(new AgentCallback(){

            public void definedStream(StreamDefinition streamDefinition, int tenantID) {
                TestWso2EventServer.this.log.info((Object)("StreamDefinition " + streamDefinition));
            }

            public void removeStream(StreamDefinition streamDefinition, int tenantID) {
            }

            public void receive(List<Event> eventList, Credentials credentials) {
                TestWso2EventServer.this.log.info((Object)("eventListSize=" + eventList.size() + " eventList " + eventList + " for username " + credentials.getUsername()));
            }
        });
        if (protocol.equalsIgnoreCase("binary")) {
            this.binaryDataReceiver = new BinaryDataReceiver(new BinaryDataReceiverConfiguration(receiverPort + 100, receiverPort), (DataBridgeReceiverService)databridge);
            try {
                this.binaryDataReceiver.start();
            }
            catch (IOException e) {
                this.log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.thriftDataReceiver = new ThriftDataReceiver(receiverPort, (DataBridgeReceiverService)databridge);
            this.thriftDataReceiver.start(host);
        }
        this.log.info((Object)"Test Server Started");
    }

    public void stop() {
        if (this.thriftDataReceiver != null) {
            this.thriftDataReceiver.stop();
        }
        if (this.binaryDataReceiver != null) {
            this.binaryDataReceiver.stop();
        }
        this.log.info((Object)"Test Server Stopped");
    }
}

