/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen.service.ajax;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.codegen.service.WSDLMetaDataFactory;

public class DynamicCodeGeneratorService {
    private static Log log = LogFactory.getLog((Class)DynamicCodeGeneratorService.class);

    public String generate(String serviceName) throws AxisFault {
        MessageContext currentMessageContext = MessageContext.getCurrentMessageContext();
        AxisConfiguration axisConfiguration = currentMessageContext.getConfigurationContext().getAxisConfiguration();
        AxisService service = axisConfiguration.getService(serviceName);
        if (service == null) {
            String message = "Service " + serviceName + " cannot be found.";
            log.error((Object)message);
            throw new AxisFault(message);
        }
        Parameter enableMTOM = service.getParameter("enableMTOM");
        if (enableMTOM != null && enableMTOM.getValue().equals("true")) {
            throw new AxisFault("Try It feature is not available for MTOM enabled services");
        }
        Object parameterValue = service.getParameterValue("WSDLSupplier");
        if (parameterValue != null) {
            String message = "RPC/ENC WSDL found. Axis2 does not support RPC/ENC encoding scheme";
            log.warn((Object)message);
            throw new AxisFault(message);
        }
        WSDLMetaDataFactory wsdlMetaDataFactory = WSDLMetaDataFactory.getFactory("2.0", serviceName, MessageContext.getCurrentMessageContext());
        WSDLMetaDataFactory.UniqueOutputDirInfo uniqueOutputDirInfo = wsdlMetaDataFactory.generateUniqueCodegenOutputDir();
        String uuidTryit = uniqueOutputDirInfo.getUuid();
        String outputDir = wsdlMetaDataFactory.generateUniqueDir("dynamic_codegen", uniqueOutputDirInfo).getOutputDir();
        String wsdlFileURI = wsdlMetaDataFactory.getWSDLFileURI(outputDir);
        try {
            FileInputStream wsdl2InStream = new FileInputStream(new File(wsdlFileURI));
            InputStream wsdl2sigXSLTStream = this.getClass().getClassLoader().getResourceAsStream("wsdl2sig.xslt");
            StreamSource wsdl2Source = new StreamSource(wsdl2InStream);
            StreamSource wsdl2sigXSLTSource = new StreamSource(wsdl2sigXSLTStream);
            DocumentBuilder docB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docB.newDocument();
            DOMResult result = new DOMResult(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(wsdl2sigXSLTSource);
            transformer.transform(wsdl2Source, result);
            DOMSource xmlSource = new DOMSource(doc);
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
            }
            WSDLMetaDataFactory.UniqueOutputDirInfo jsstubUniqueOutputDirInfo = wsdlMetaDataFactory.generateUniqueCodegenOutputDir();
            String uuidJsstub = jsstubUniqueOutputDirInfo.getUuid();
            String jstubOutputDir = wsdlMetaDataFactory.generateUniqueDir("dynamic_codegen", jsstubUniqueOutputDirInfo).getOutputDir();
            File jstubOutputDirFile = new File(jstubOutputDir);
            jstubOutputDirFile.mkdirs();
            File jsStubFle = new File(jstubOutputDir, serviceName + ".stub.js");
            FileOutputStream jsStubOutputStream = new FileOutputStream(jsStubFle);
            StreamResult jsStubResult = new StreamResult(jsStubOutputStream);
            InputStream jsStubXSLTStream = this.getClass().getClassLoader().getResourceAsStream("jsstub.xslt");
            StreamSource jsStubXSLSource = new StreamSource(jsStubXSLTStream);
            transformer = TransformerFactory.newInstance().newTransformer(jsStubXSLSource);
            transformer.transform(xmlSource, jsStubResult);
            JSStubFilter jsStubFileFilter = new JSStubFilter();
            String absolutePath = null;
            File[] files0 = jstubOutputDirFile.listFiles(jsStubFileFilter);
            if (files0 != null && files0[0] != null && files0[0].getAbsoluteFile() != null) {
                absolutePath = files0[0].getAbsoluteFile().getAbsolutePath();
                fileResourcesMap.put(uuidJsstub, absolutePath);
            }
            if (absolutePath == null) {
                throw new AxisFault(DynamicCodeGeneratorService.class.getName() + " cannot continue" + " since an instance of jsstub.xslt is not available");
            }
            InputStream tryItXSLTStream = this.getClass().getClassLoader().getResourceAsStream("tryit.xslt");
            StreamSource tryItXSLSource = new StreamSource(tryItXSLTStream);
            File tryItOutFile = new File(outputDir, serviceName + ".html");
            FileOutputStream tryItOutFileStream = new FileOutputStream(tryItOutFile);
            StreamResult tryItResult = new StreamResult(tryItOutFileStream);
            transformer = TransformerFactory.newInstance().newTransformer(tryItXSLSource);
            transformer.setParameter("wsrequest-location", "js/WSRequest.js");
            transformer.setParameter("stub-location", "filedownload?id=" + uuidJsstub);
            String injectValue = "<div><h4><a href=\"#\" onClick=\"javascript:top.showServiceInitializer(); return false;\">Services</a>&nbsp;&gt;&nbsp;<a href=\"#\" onClick=\"javascript:top.listServiceData('" + serviceName + "'); return false;\">" + serviceName + "</a>&nbsp;&gt;&nbsp;" + "Try Web Service" + "</h4>" + "</div>";
            transformer.setParameter("image-path", "extensions/core/images/");
            transformer.setParameter("breadcrumbs", injectValue);
            transformer.transform(xmlSource, tryItResult);
            TryItFilter tryItFileFilter = new TryItFilter();
            File[] files1 = new File(outputDir).listFiles(tryItFileFilter);
            if (files1 != null && files1[0] != null && files1[0].getAbsoluteFile() != null) {
                fileResourcesMap.put(uuidTryit, files1[0].getAbsoluteFile().getAbsolutePath());
            }
            String contextRoot = "";
            if (!MessageContext.getCurrentMessageContext().getConfigurationContext().getContextRoot().equals("/")) {
                contextRoot = MessageContext.getCurrentMessageContext().getConfigurationContext().getContextRoot();
            }
            log.debug((Object)("Try it page has been generated for the service: " + serviceName));
            return contextRoot + "/filedownload" + "?id=" + uuidTryit;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private class JSStubFilter
    implements FileFilter {
        private JSStubFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".stub.js");
        }
    }

    private class TryItFilter
    implements FileFilter {
        private TryItFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".html");
        }
    }
}

