/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen.service.ajax;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.wso2.codegen.service.ServiceEndpointsData;
import org.wso2.codegen.service.WSDLMetaData;
import org.wso2.codegen.service.WSDLMetaDataFactory;
import org.wso2.codegen.service.ajax.AjaxClientGeneratorServiceSkeletonInterface;

public class AjaxClientGeneratorService
implements AjaxClientGeneratorServiceSkeletonInterface {
    public String generateAjaxClient(String serviceName, String wsdlLocation) {
        DynamicClientFileFilter filter;
        File f;
        File[] files;
        WSDLMetaDataFactory wsdlMetaDataFactory = WSDLMetaDataFactory.getFactory("1.1", serviceName, MessageContext.getCurrentMessageContext());
        WSDLMetaDataFactory.UniqueOutputDirInfo uniqueOutputDirInfo = wsdlMetaDataFactory.generateUniqueCodegenOutputDir();
        String uuid = uniqueOutputDirInfo.getUuid();
        String codegenOutputDir = uniqueOutputDirInfo.getOutputDir();
        String wsdlDir = wsdlMetaDataFactory.generateUniqueDir("dynamic_client", uniqueOutputDirInfo).getOutputDir();
        try {
            ServiceEndpointsData sed;
            String[] endpointNames;
            WSDLMetaData wsdlMetaData = wsdlMetaDataFactory.createWSDLMetaData(new URL(wsdlLocation));
            Pattern pattern = Pattern.compile(".*SOAP12port_https\\d*");
            ServiceEndpointsData[] serviceEndpointsData = wsdlMetaData.getServiceEndpointsData();
            String endpoint = null;
            if (serviceEndpointsData != null && (endpointNames = (sed = serviceEndpointsData[0]).getEndpointNames()) != null) {
                for (int i = 0; i < endpointNames.length; ++i) {
                    Matcher matcher = pattern.matcher(endpointNames[i]);
                    if (!matcher.matches()) continue;
                    endpoint = endpointNames[i];
                    break;
                }
            }
            String[] args = new String[]{"-uri", wsdlMetaDataFactory.getWSDLLocation().toString(), "-o", codegenOutputDir, "-l", "ajax", "-pn", endpoint, "-sn", serviceName};
            CommandLineOptionParser optionParser = new CommandLineOptionParser(args);
            new CodeGenerationEngine(optionParser).generate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        if ((files = (f = new File(codegenOutputDir + File.separator + "src" + File.separator)).listFiles(filter = new DynamicClientFileFilter())) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
            fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
        }
        String contextRoot = "";
        if (!MessageContext.getCurrentMessageContext().getConfigurationContext().getContextRoot().equals("/")) {
            contextRoot = MessageContext.getCurrentMessageContext().getConfigurationContext().getContextRoot();
        }
        return contextRoot + "/filedownload" + "?id=" + uuid;
    }

    private class DynamicClientFileFilter
    implements FileFilter {
        private DynamicClientFileFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".html");
        }
    }
}

