/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.das.integration.common.ui.page.main;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.das.integration.common.ui.page.LoginPage;
import org.wso2.das.integration.common.ui.page.util.UIElementMapper;

public class HomePage {
    private static final Log log = LogFactory.getLog(HomePage.class);
    private WebDriver driver;
    private boolean isCloudEnvironment = false;
    private boolean isTenant = false;

    public HomePage(WebDriver driver) throws IOException {
        this.driver = driver;
        if (!driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("home.dashboard.middle.text"))).getText().toLowerCase().contains("home")) {
            throw new IllegalStateException("This is not the home page");
        }
    }

    public HomePage(WebDriver driver, boolean isCloudEnvironment) throws IOException {
        this.driver = driver;
        this.isCloudEnvironment = isCloudEnvironment;
        if (isCloudEnvironment) {
            if (!driver.findElement(By.className((String)"dashboard-title")).getText().toLowerCase().contains("quick start dashboard")) {
                throw new IllegalStateException("This is not the cloud home page");
            }
        } else if (!driver.findElement(By.id((String)UIElementMapper.getInstance().getElement("home.dashboard.middle.text"))).getText().toLowerCase().contains("home")) {
            throw new IllegalStateException("This is not the home page");
        }
    }

    public HomePage(boolean isTenant, WebDriver driver) throws IOException {
        this.isTenant = isTenant;
        if (this.isTenant && !driver.getCurrentUrl().contains("loginStatus=true")) {
            throw new IllegalStateException("This is not the home page");
        }
    }

    public LoginPage logout() throws IOException {
        this.driver.findElement(By.xpath((String)UIElementMapper.getInstance().getElement("home.greg.sign.out.xpath"))).click();
        return new LoginPage(this.driver, this.isCloudEnvironment);
    }

    private int findMenuItem(int startIndex, String name, List<WebElement> menuItems) {
        for (int i = startIndex; i < menuItems.size(); ++i) {
            WebElement item = menuItems.get(i);
            if (!name.equals(item.getText())) continue;
            return i;
        }
        return menuItems.size();
    }

    public WebDriver clickMenu(String ... itemNames) {
        List menuItems = this.driver.findElements(By.cssSelector((String)".main li"));
        int index = 0;
        for (String itemName : itemNames) {
            index = this.findMenuItem(index, itemName, menuItems);
        }
        if (index >= menuItems.size()) {
            throw new IllegalStateException("Menu item with text '" + Arrays.toString(itemNames) + "' does not exits.");
        }
        ((WebElement)menuItems.get(index)).findElement(By.tagName((String)"a")).click();
        return this.driver;
    }
}

