/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.ws.dataservice.DBDeployer;
import org.wso2.ws.dataservice.QueryElement;

public class CallQuery {
    private ArrayList inputParms = new ArrayList();
    private ArrayList outputParms = new ArrayList();
    private String sql;
    private String elementName;
    private String rawName;
    private ArrayList queryRefList = new ArrayList();

    public ArrayList getInputParms() {
        return this.inputParms;
    }

    public void addInputParms(QueryElement element) {
        this.inputParms.add(element);
    }

    public ArrayList getOutputParms() {
        return this.outputParms;
    }

    public void addOutputParms(QueryElement element) {
        this.outputParms.add(element);
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getRawName() {
        return this.rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }

    public ArrayList getQueryRefList() {
        return this.queryRefList;
    }

    public void populateCallQuery(OMElement queryElement) {
        OMElement resultElement;
        Iterator inputsIterator = queryElement.getChildrenWithName(new QName("param"));
        while (inputsIterator.hasNext()) {
            OMElement input = (OMElement)inputsIterator.next();
            String name = input.getAttributeValue(new QName("name"));
            String sqlType = input.getAttributeValue(new QName("sqlType"));
            String type = DBDeployer.getJavaTypeFromSQLType(sqlType);
            QueryElement inputElement = new QueryElement();
            inputElement.setClassType(type);
            inputElement.setName(name);
            this.addInputParms(inputElement);
        }
        OMElement sqlQuery = queryElement.getFirstChildWithName(new QName("sql"));
        if (sqlQuery != null) {
            this.sql = sqlQuery.getText();
        }
        if ((resultElement = queryElement.getFirstChildWithName(new QName("result"))) != null) {
            this.elementName = resultElement.getAttributeValue(new QName("element"));
            this.rawName = resultElement.getAttributeValue(new QName("rowName"));
            Iterator elements = resultElement.getChildrenWithName(new QName("element"));
            while (elements.hasNext()) {
                OMElement element = (OMElement)elements.next();
                QueryElement resultQueryElement = new QueryElement();
                resultQueryElement.setClassType("java.lang.String");
                resultQueryElement.setColumnName(element.getAttributeValue(new QName("column")));
                resultQueryElement.setName(element.getAttributeValue(new QName("name")));
                this.addOutputParms(resultQueryElement);
            }
            Iterator queryElements = resultElement.getChildrenWithName(new QName("call-query"));
            while (queryElements.hasNext()) {
                OMElement query = (OMElement)queryElements.next();
                this.queryRefList.add(query.getAttributeValue(new QName("href")));
            }
        }
    }
}

