/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUtils {
    private static final Log log = LogFactory.getLog((Class)DBUtils.class);
    private String configFilePath;

    public static OMNode toOM(Reader reader) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((Reader)reader);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        return staxOMBuilder.getDocumentElement();
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String config_file_parth) {
        this.configFilePath = config_file_parth;
    }

    private static OMElement processQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        Iterator iter = inputMessage.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            inputs.put(element.getLocalName(), element.getText());
        }
        OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
        return DBUtils.getResult(callQueryElement, axisService, inputs);
    }

    private static OMElement getResult(OMElement callQueryElement, AxisService axisService, HashMap inputs) {
        OMElement resultElement;
        block7: {
            resultElement = null;
            try {
                OMElement queryElement;
                String href = callQueryElement.getAttributeValue(new QName("href"));
                if (href != null) {
                    HashMap queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                    queryElement = (OMElement)queries.get(href);
                } else {
                    queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
                }
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<Integer, String> paramOrder = new HashMap<Integer, String>();
                Iterator iParams = queryElement.getChildrenWithName(new QName("param"));
                int position = 0;
                while (iParams.hasNext()) {
                    OMElement param = (OMElement)iParams.next();
                    String paramName = param.getAttributeValue(new QName("name"));
                    String sqlType = param.getAttributeValue(new QName("sqlType"));
                    params.put(paramName, sqlType);
                    paramOrder.put(new Integer(position + 1), paramName);
                    ++position;
                }
                String query = queryElement.getFirstChildWithName(new QName("sql")).getText();
                String firstPartOfSQL = query.substring(0, 6);
                if (firstPartOfSQL.equalsIgnoreCase("SELECT")) {
                    resultElement = DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, axisService, false);
                    break block7;
                }
                if (firstPartOfSQL.equalsIgnoreCase("INSERT") || firstPartOfSQL.equalsIgnoreCase("UPDATE") || firstPartOfSQL.equalsIgnoreCase("DELETE") || firstPartOfSQL.equalsIgnoreCase("CREATE")) {
                    resultElement = DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, axisService, true);
                    break block7;
                }
                throw new UnsupportedOperationException("The SQL " + query + " is not supported yet..");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultElement;
    }

    private static OMElement getSelectResult(OMElement queryElement, HashMap inputValues, HashMap params, HashMap paramOrder, AxisService axisService, boolean isDML) throws AxisFault {
        OMElement resultElement = null;
        Connection conn = null;
        String sqlQuery = queryElement.getFirstChildWithName(new QName("sql")).getText();
        try {
            Parameter dbConnectionParam = axisService.getAxisConfiguration().getParameter("org.wso2.ws.dataservice.dbconnection");
            if (dbConnectionParam == null) {
                throw new AxisFault("Database connection not found in AxisConfiguration");
            }
            conn = (Connection)dbConnectionParam.getValue();
            conn.setAutoCommit(false);
            PreparedStatement preparedStatement = DBUtils.getProcessedPreparedStatement(inputValues, params, paramOrder, conn, sqlQuery);
            int responseCode = -1;
            ResultSet rs = null;
            if (isDML) {
                responseCode = preparedStatement.executeUpdate();
            } else {
                rs = preparedStatement.executeQuery();
            }
            OMElement result = queryElement.getFirstChildWithName(new QName("result"));
            String wrapperElementName = result.getAttributeValue(new QName("element"));
            String rowElementName = result.getAttributeValue(new QName("rowName"));
            String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
            resultElement = fac.createOMElement(wrapperElementName, omNs);
            if (isDML) {
                resultElement.setText("Your query executed successfully. Return code from the database was " + responseCode);
            } else {
                if (!axisService.isElementFormDefault()) {
                    omNs = fac.createOMNamespace("", "data");
                }
                while (rs.next()) {
                    HashMap<String, String> elementValues = new HashMap<String, String>();
                    int columnCount = rs.getMetaData().getColumnCount();
                    OMElement row = fac.createOMElement(rowElementName, omNs);
                    if (rowElementName == null) {
                        row = resultElement;
                    }
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = rs.getMetaData().getColumnLabel(i);
                        String columnValue = rs.getString(columnName);
                        elementValues.put(columnName, columnValue);
                    }
                    Iterator elements = result.getChildElements();
                    boolean useAsParamToNextQuery = false;
                    while (elements.hasNext()) {
                        OMElement element = (OMElement)elements.next();
                        if (element.getLocalName().equals("element")) {
                            String elementValue;
                            String displayTagName = element.getAttributeValue(new QName("name"));
                            String resultSetFieldName = element.getAttributeValue(new QName("column"));
                            if (resultSetFieldName == null) {
                                resultSetFieldName = element.getAttributeValue(new QName("param"));
                                useAsParamToNextQuery = true;
                            }
                            if (useAsParamToNextQuery) {
                                elementValue = (String)params.get(resultSetFieldName);
                                elementValues.put(resultSetFieldName, elementValue);
                            } else {
                                elementValue = (String)elementValues.get(resultSetFieldName);
                            }
                            if (columnDefalut == null || columnDefalut.equals("element")) {
                                OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                                rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                                row.addChild((OMNode)rowElement);
                                continue;
                            }
                            if (!columnDefalut.equals("attribute")) continue;
                            row.addAttribute(displayTagName, elementValue, omNs);
                            continue;
                        }
                        if (!element.getLocalName().equals("call-query")) continue;
                        OMElement rowElement = DBUtils.getResult(element, axisService, elementValues);
                        row.addChild((OMNode)rowElement);
                    }
                    if (rowElementName == null) continue;
                    resultElement.addChild((OMNode)row);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new AxisFault("Exception occurred while trying to execute the SQL statement.", (Throwable)e);
        }
        return resultElement;
    }

    public static OMElement invoke(MessageContext msgContext) {
        AxisOperation axisOp = msgContext.getAxisOperation();
        AxisService axisService = msgContext.getAxisService();
        OMElement inputMessage = msgContext.getEnvelope().getBody().getFirstElement();
        OMElement operationElement = (OMElement)axisOp.getParameterValue("org.wso2.ws.dataservice.db_operation_element");
        return DBUtils.processQuery(operationElement, axisService, inputMessage);
    }

    public static Connection createConnection(AxisService axisService) throws SQLException, ClassNotFoundException {
        try {
            log.info((Object)("Creating database connection for " + axisService.getName()));
            Class.forName((String)axisService.getParameterValue("org.wso2.ws.dataservice.driver")).newInstance();
            Properties props = new Properties();
            props.put("user", axisService.getParameterValue("org.wso2.ws.dataservice.user"));
            props.put("password", axisService.getParameterValue("org.wso2.ws.dataservice.password"));
            Connection conn = DriverManager.getConnection((String)axisService.getParameterValue("org.wso2.ws.dataservice.protocol"), props);
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("JDBC driver not available in classpath : " + e.getMessage()));
            throw e;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }

    public static PreparedStatement getProcessedPreparedStatement(HashMap inputs, HashMap params, HashMap paramOrder, Connection conn, String sqlStatement) throws SQLException {
        PreparedStatement sqlQuery = conn.prepareStatement(sqlStatement);
        Set paramNames = params.keySet();
        Object[] pramNameArray = paramNames.toArray();
        for (int i = 0; i < pramNameArray.length; ++i) {
            String paramName = (String)paramOrder.get(new Integer(i + 1));
            String sqlType = (String)params.get(paramName);
            String value = (String)inputs.get(paramName);
            if (sqlType == null) {
                sqlQuery.setString(i + 1, value);
                continue;
            }
            if (sqlType.equals("INTEGER")) {
                sqlQuery.setInt(i + 1, Integer.parseInt(value));
                continue;
            }
            if (sqlType.equals("STRING")) {
                sqlQuery.setString(i + 1, value);
                continue;
            }
            if (!sqlType.equals("DOUBLE")) continue;
            sqlQuery.setDouble(i + 1, Double.parseDouble(value));
        }
        return sqlQuery;
    }
}

