/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.wso2.ws.dataservice.CallQuery;
import org.wso2.ws.dataservice.QueryElement;

public class DataServiceDocLitWrappedSchemaGenerator {
    private AxisService axisService;
    protected Map schemaMap = new Hashtable();
    protected TypeTable typeTable = new TypeTable();
    protected String schemaTargetNameSpace;
    protected String schema_namespace_prefix;
    public static final String NAME_SPACE_PREFIX = "ax2";
    private static int prefixCount = 1;
    protected String attrFormDefault = null;
    protected String elementFormDefault = null;
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    protected Map targetNamespacePrefixMap = new Hashtable();
    private Map queryRefMap;

    public DataServiceDocLitWrappedSchemaGenerator(AxisService axisService, Map queryRefMap) {
        this.axisService = axisService;
        this.schemaTargetNameSpace = axisService.getTargetNamespace();
        axisService.setSchemaTargetNamespace(this.schemaTargetNameSpace);
        this.schema_namespace_prefix = axisService.getSchemaTargetNamespacePrefix();
        this.queryRefMap = queryRefMap;
    }

    public void generateSchema() {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            this.generateSchemaforOperation(axisOperation);
        }
        this.axisService.addSchema(this.schemaMap.values());
    }

    private void generateSchemaforOperation(AxisOperation axisOperation) {
        String operationName = axisOperation.getName().getLocalPart();
        AxisMessage inMessage = axisOperation.getMessage("In");
        Parameter callQueryParamter = axisOperation.getParameter("CallQuery");
        if (callQueryParamter == null) {
            return;
        }
        CallQuery callQuery = (CallQuery)callQueryParamter.getValue();
        if (inMessage != null) {
            inMessage.setName(operationName + "Request");
        }
        this.generateSchemaForInput(operationName, callQuery, inMessage);
        AxisMessage outMessage = axisOperation.getMessage("Out");
        outMessage.setName(operationName + "Response");
        if (callQuery.getElementName() != null) {
            this.generateSchemaForOutput(callQuery, false);
            outMessage.setElementQName(this.typeTable.getQNamefortheType(callQuery.getElementName()));
        }
    }

    private void generateSchemaForOutput(CallQuery callQuery, boolean addComplexType) {
        XmlSchemaComplexType methodSchemaType = this.createSchemaTypeForMethodPart(callQuery.getElementName(), addComplexType);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        methodSchemaType.setParticle((XmlSchemaParticle)sequence);
        QName rawQName = this.generateSchemaForRaw(callQuery);
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(callQuery.getRawName());
        elt1.setSchemaTypeName(rawQName);
        sequence.getItems().add((XmlSchemaObject)elt1);
        elt1.setMinOccurs(0L);
        elt1.setNillable(true);
        elt1.setMaxOccurs(Long.MAX_VALUE);
    }

    private QName generateSchemaForRaw(CallQuery callQuery) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType methodSchemaType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, callQuery.getRawName(), this.schema_namespace_prefix));
        if (methodSchemaType == null) {
            methodSchemaType = new XmlSchemaComplexType(xmlSchema);
            methodSchemaType.setName(callQuery.getRawName());
            xmlSchema.getItems().add((XmlSchemaObject)methodSchemaType);
            xmlSchema.getElements().add(elementName, (XmlSchemaObject)methodSchemaType);
        }
        this.typeTable.addComplexSchema(callQuery.getRawName(), elementName);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        methodSchemaType.setParticle((XmlSchemaParticle)sequence);
        ArrayList outParams = callQuery.getOutputParms();
        for (int i = 0; i < outParams.size(); ++i) {
            QueryElement queryElement = (QueryElement)outParams.get(i);
            this.generateSchemaForQueryElement(queryElement, sequence);
        }
        ArrayList hrefs = callQuery.getQueryRefList();
        if (hrefs != null) {
            for (int i = 0; i < hrefs.size(); ++i) {
                String ref = (String)hrefs.get(i);
                QName refQname = this.typeTable.getQNamefortheType(ref);
                if (refQname != null) continue;
                CallQuery query = (CallQuery)this.queryRefMap.get(ref);
                if (query != null) {
                    refQname = this.generateTypeforRef(query);
                }
                if (refQname == null) continue;
                XmlSchemaElement elt1 = new XmlSchemaElement();
                elt1.setName(query.getElementName());
                elt1.setSchemaTypeName(refQname);
                sequence.getItems().add((XmlSchemaObject)elt1);
                elt1.setMinOccurs(0L);
                elt1.setNillable(true);
            }
        }
        return this.typeTable.getQNamefortheType(callQuery.getRawName());
    }

    private QName generateTypeforRef(CallQuery query) {
        if (query.getElementName() != null) {
            this.generateSchemaForOutput(query, true);
            return this.typeTable.getQNamefortheType(query.getElementName());
        }
        return null;
    }

    private void generateSchemaForQueryElement(QueryElement queryElement, XmlSchemaSequence sequence) {
        QName schemaTypeName = this.typeTable.getSimpleSchemaTypeName(queryElement.getClassType());
        if (schemaTypeName != null) {
            XmlSchemaElement elt1 = new XmlSchemaElement();
            elt1.setName(queryElement.getName());
            elt1.setSchemaTypeName(schemaTypeName);
            sequence.getItems().add((XmlSchemaObject)elt1);
            elt1.setMinOccurs(0L);
            elt1.setNillable(true);
        }
    }

    private void generateSchemaForInput(String operationName, CallQuery callQuery, AxisMessage inMessage) {
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        XmlSchemaComplexType methodSchemaType = this.createSchemaTypeForMethodPart(operationName, false);
        methodSchemaType.setParticle((XmlSchemaParticle)sequence);
        ArrayList inputParams = callQuery.getInputParms();
        for (int i = 0; i < inputParams.size(); ++i) {
            QueryElement queryElement = (QueryElement)inputParams.get(i);
            this.generateSchemaForQueryElement(queryElement, sequence);
        }
        inMessage.setElementQName(this.typeTable.getQNamefortheType(operationName));
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String operationName, boolean addComplextype) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, operationName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setName(operationName);
            globalElement.setQName(elementName);
            if (addComplextype) {
                complexType.setName(operationName);
                xmlSchema.getItems().add((XmlSchemaObject)complexType);
                globalElement.setSchemaTypeName(complexType.getQName());
            } else {
                globalElement.setSchemaType((XmlSchemaType)complexType);
            }
            xmlSchema.getItems().add((XmlSchemaObject)globalElement);
            xmlSchema.getElements().add(elementName, (XmlSchemaObject)globalElement);
        }
        this.typeTable.addComplexSchema(operationName, elementName);
        return complexType;
    }

    private XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
            xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        }
        return xmlSchema;
    }

    protected String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }

    protected XmlSchemaForm getAttrFormDefaultSetting() {
        if ("unqualified".equals(this.getAttrFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    protected XmlSchemaForm getElementFormDefaultSetting() {
        if ("unqualified".equals(this.getElementFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    protected XmlSchemaComplexType getComplexTypeForElement(XmlSchema xmlSchema, QName name) {
        Iterator iterator = xmlSchema.getItems().getIterator();
        while (iterator.hasNext()) {
            XmlSchemaObject object = (XmlSchemaObject)iterator.next();
            if (!(object instanceof XmlSchemaElement) || !((XmlSchemaElement)object).getQName().equals(name)) continue;
            return (XmlSchemaComplexType)((XmlSchemaElement)object).getSchemaType();
        }
        return null;
    }
}

