/*
 * Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.ws.dataservice;

import org.apache.axiom.om.OMElement;

import javax.xml.namespace.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CallQuery {

    private ArrayList inputParms;
    private ArrayList outputParms;
    private String sql;
    private String elementName;
    private String rawName;
    private ArrayList queryRefList;


    public CallQuery() {
        inputParms = new ArrayList();
        outputParms = new ArrayList();
        queryRefList = new ArrayList();
    }

    public ArrayList getInputParms() {
        return inputParms;
    }

    public void addInputParms(QueryElement element) {
        inputParms.add(element);
    }

    public ArrayList getOutputParms() {
        return outputParms;
    }

    public void addOutputParms(QueryElement element) {
        outputParms.add(element);
    }


    public String getSql() {
        return sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }


    public String getElementName() {
        return elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getRawName() {
        return rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }


    public ArrayList getQueryRefList() {
        return queryRefList;
    }

    public void populateCallQuery(OMElement queryElement) {
        Iterator inputsIterator = queryElement.getChildrenWithName(new QName("param"));
        while (inputsIterator.hasNext()) {
            OMElement input = (OMElement) inputsIterator.next();
            String name = input.getAttributeValue(new QName("name"));
            String sqlType = input.getAttributeValue(new QName("sqlType"));
            String type = DBDeployer.getJavaTypeFromSQLType(sqlType);
            QueryElement inputElement = new QueryElement();
            inputElement.setClassType(type);
            
            //String withParamName = getExternalParameterName(queryElement, paramsPerCallQueryMap, name);
            //if(withParamName != null){
            //    inputElement.setName(withParamName);
            //}else{
                inputElement.setName(name);    
            //}
            addInputParms(inputElement);
        }
        OMElement sqlQuery = queryElement.getFirstChildWithName(new QName("sql"));
        if (sqlQuery != null) {
            sql = sqlQuery.getText();
        }

        OMElement resultElement = queryElement.getFirstChildWithName(new QName("result"));
        if (resultElement != null) {
            elementName = resultElement.getAttributeValue(new QName("element"));
            rawName = resultElement.getAttributeValue(new QName("rowName"));
            //processing elements
            Iterator elements = resultElement.getChildrenWithName(new QName("element"));
            while (elements.hasNext()) {
                OMElement element = (OMElement) elements.next();
                QueryElement resultQueryElement = new QueryElement();
                resultQueryElement.setClassType("java.lang.String");
                resultQueryElement.setColumnName(element.getAttributeValue(new QName("column")));
                resultQueryElement.setName(element.getAttributeValue(new QName("name")));
                addOutputParms(resultQueryElement);
            }
            Iterator queryElements = resultElement.getChildrenWithName(new QName("call-query"));
            while (queryElements.hasNext()) {
                OMElement query = (OMElement) queryElements.next();
                queryRefList.add(query.getAttributeValue(new QName("href")));
            }
        }

    }

    private String getExternalParameterName(OMElement queryElement,
            HashMap paramsPerCallQueryMap, String name) {
        String withParamName = null;
        String queryId = queryElement.getAttributeValue(new QName("id"));
        HashMap callQueryParamNames = (HashMap)paramsPerCallQueryMap.get(queryId);
        if(callQueryParamNames != null){
            withParamName = (String) callQueryParamNames.get(name);
        }
        return withParamName;
    }
    
    
    
}
