/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.wso2.ws.dataservice.CallQuery;
import org.wso2.ws.dataservice.DBConstants;
import org.wso2.ws.dataservice.DBMessageReceiver;
import org.wso2.ws.dataservice.DBUtils;
import org.wso2.ws.dataservice.DataServiceDocLitWrappedSchemaGenerator;
import org.wso2.ws.dataservice.JNDIUtils;

public class DBDeployer
implements Deployer,
DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)DBDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;
    private DBMessageReceiver dbMessageReceiver;
    private String repoDir = null;
    private String extension = null;
    private static HashMap conversionType = null;

    private static HashMap getConversionTable() {
        if (conversionType == null) {
            conversionType = new HashMap();
            conversionType.put("CHAR", "java.lang.String");
            conversionType.put("STRING", "java.lang.String");
            conversionType.put("VARCHAR", "java.lang.String");
            conversionType.put("TEXT", "java.lang.String");
            conversionType.put("NUMERIC", "java.math.BigDecimal");
            conversionType.put("DECIMAL", "java.math.BigDecimal");
            conversionType.put("MONEY", "java.math.BigDecimal");
            conversionType.put("SMALLMONEY", "java.math.BigDecimal");
            conversionType.put("BIT", "boolean");
            conversionType.put("TINYINT", "byte");
            conversionType.put("SMALLINT", "short");
            conversionType.put("INTEGER", "int");
            conversionType.put("BIGINT", "long");
            conversionType.put("REAL", "float");
            conversionType.put("FLOAT", "double");
            conversionType.put("DOUBLE", "double");
            conversionType.put("BINARY", "base64Binary");
            conversionType.put("VARBINARY", "base64Binary");
            conversionType.put("LONG VARBINARY", "base64Binary");
            conversionType.put("IMAGE", "base64Binary");
            conversionType.put("DATE", "java.sql.Date");
            conversionType.put("TIME", "java.sql.Time");
            conversionType.put("TIMESTAMP", "java.sql.Timestamp");
        }
        return conversionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        StringWriter errorWriter = new StringWriter();
        String serviceStatus = "";
        try {
            try {
                deploymentFileData.setClassLoader(this.axisConfig.getSystemClassLoader());
                AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
                serviceGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
                ArrayList serviceList = this.processService(deploymentFileData, serviceGroup, this.configCtx);
                DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, (ArrayList)serviceList, (URL)deploymentFileData.getFile().toURL(), (DeploymentFileData)deploymentFileData, (AxisConfiguration)this.axisConfig);
                log.info((Object)Messages.getMessage((String)"deployingws", (String)deploymentFileData.getName()));
            }
            catch (DeploymentException de) {
                de.printStackTrace();
                log.error((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName(), (String)de.getMessage()), (Throwable)de);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                de.printStackTrace(error_ptintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                Object var8_15 = null;
                if (!serviceStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
                return;
            }
            catch (AxisFault axisFault) {
                log.error((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName(), (String)axisFault.getMessage()), (Throwable)axisFault);
                PrintWriter errorPrintWriter = new PrintWriter(errorWriter);
                axisFault.printStackTrace(errorPrintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                Object var8_16 = null;
                if (!serviceStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
                return;
            }
            catch (Exception e) {
                if (log.isInfoEnabled()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    log.info((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName(), (String)sw.getBuffer().toString()));
                }
                PrintWriter errorPrintWriter = new PrintWriter(errorWriter);
                e.printStackTrace(errorPrintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                Object var8_17 = null;
                if (!serviceStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
                return;
            }
            catch (Throwable t) {
                if (log.isInfoEnabled()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    log.info((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName(), (String)sw.getBuffer().toString()));
                }
                PrintWriter errorPrintWriter = new PrintWriter(errorWriter);
                t.printStackTrace(errorPrintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                Object var8_18 = null;
                if (!serviceStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
                return;
            }
            Object var8_14 = null;
            if (!serviceStatus.startsWith("Error:")) return;
            this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            return;
        }
        catch (Throwable throwable) {
            Object var8_19 = null;
            if (!serviceStatus.startsWith("Error:")) throw throwable;
            this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            throw throwable;
        }
    }

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
        configCtx.setProperty("local_org.wso2.ws.dataservice.db_service_repo", (Object)this.repoDir);
        configCtx.setProperty("local_org.wso2.ws.dataservice.db_service_extension", (Object)this.extension);
    }

    public void setDirectory(String repoDir) {
        this.repoDir = repoDir;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void unDeploy(String fileName) {
        try {
            fileName = DeploymentEngine.getAxisServiceName((String)fileName);
            AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
            this.configCtx.removeServiceGroupContext(serviceGroup);
            log.info((Object)Messages.getMessage((String)"serviceremoved", (String)fileName));
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService(fileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AxisService createDBService(String configFilePath, AxisConfiguration axisConfiguration) throws AxisFault {
        AxisService axisService;
        DBMessageReceiver dbMessageReceiver = this.getDbMessageReceiver();
        HashMap<String, CallQuery> callQueryMap = new HashMap<String, CallQuery>();
        FileInputStream fis = null;
        String dataSourceType = "RDBMS";
        try {
            try {
                Connection dbConnection;
                String propValue;
                String propName;
                fis = new FileInputStream(configFilePath);
                OMElement configElement = new StAXOMBuilder((InputStream)fis).getDocumentElement();
                configElement.build();
                String serviceName = configElement.getAttributeValue(new QName("name")).toString();
                axisService = new AxisService(serviceName);
                OMElement connection = configElement.getFirstChildWithName(new QName("config"));
                HashMap props = this.getProperties(connection);
                ArrayList<String> reqProps = new ArrayList<String>();
                reqProps.add("org.wso2.ws.dataservice.driver");
                reqProps.add("org.wso2.ws.dataservice.protocol");
                reqProps.add("org.wso2.ws.dataservice.user");
                reqProps.add("org.wso2.ws.dataservice.password");
                reqProps.add("org.wso2.ws.dataservice.db_config_element");
                for (int i = 0; i < reqProps.size(); ++i) {
                    propName = (String)reqProps.get(i);
                    propValue = (String)props.get(propName);
                    if (propValue == null) continue;
                    axisService.addParameter(new Parameter(propName, (Object)propValue));
                }
                Iterator it = props.keySet().iterator();
                while (it.hasNext()) {
                    propName = (String)it.next();
                    if (reqProps.contains(propName)) continue;
                    if (propName.equals("csv_datasource")) {
                        dataSourceType = "CSV";
                    } else if (propName.equals("excel_datasource")) {
                        dataSourceType = "EXCEL";
                    } else if (propName.equals("jndi_context_class")) {
                        dataSourceType = "JNDI";
                    }
                    propValue = (String)props.get(propName);
                    axisService.addParameter(new Parameter(propName, (Object)propValue));
                }
                if (dataSourceType.equals("RDBMS")) {
                    dbConnection = DBUtils.createConnection(axisService);
                    if (dbConnection == null) throw new AxisFault("Could not establish a connection to database.");
                    axisService.addParameter("org.wso2.ws.dataservice.dbconnection", (Object)dbConnection);
                } else if (dataSourceType.equals("JNDI")) {
                    dbConnection = JNDIUtils.createConnection(axisService);
                    if (dbConnection == null) throw new AxisFault("Could not establish a connection to database.");
                    axisService.addParameter("org.wso2.ws.dataservice.dbconnection", (Object)dbConnection);
                }
                axisService.addParameter(new Parameter("serviceType", (Object)"data_service"));
                axisService.addParameter(new Parameter("org.wso2.ws.dataservice.db_service_config_file", (Object)configFilePath));
                Iterator queries = configElement.getChildrenWithName(new QName("query"));
                HashMap<String, OMElement> queryMap = new HashMap<String, OMElement>();
                while (queries.hasNext()) {
                    OMElement queryElement = (OMElement)queries.next();
                    String queryId = queryElement.getAttributeValue(new QName("id"));
                    queryMap.put(queryId, queryElement);
                    CallQuery callQuery = new CallQuery();
                    callQuery.populateCallQuery(queryElement);
                    callQueryMap.put(queryId, callQuery);
                }
                axisService.addParameter(new Parameter("org.wso2.ws.dataservice.db_query_elements", queryMap));
                axisService.setTargetNamespace(DBConstants.WSO2_NAMESPACE);
                axisService.setElementFormDefault(false);
                if ("CSV".equals(dataSourceType)) {
                    axisService.addParameter(new Parameter("DATASOURCE_TYPE", (Object)"CSV"));
                } else if ("EXCEL".equals(dataSourceType)) {
                    axisService.addParameter(new Parameter("DATASOURCE_TYPE", (Object)"EXCEL"));
                } else if ("JNDI".equals(dataSourceType)) {
                    axisService.addParameter(new Parameter("DATASOURCE_TYPE", (Object)"JNDI"));
                } else {
                    axisService.addParameter(new Parameter("DATASOURCE_TYPE", (Object)"RDBMS"));
                }
                Iterator ops = configElement.getChildrenWithName(new QName("operation"));
                while (ops.hasNext()) {
                    OMElement operation = (OMElement)ops.next();
                    String opName = operation.getAttributeValue(new QName("name"));
                    InOutAxisOperation axisOperation = new InOutAxisOperation(new QName(opName));
                    axisOperation.setMessageReceiver((MessageReceiver)dbMessageReceiver);
                    axisOperation.setStyle("document");
                    this.axisConfig.getPhasesInfo().setOperationPhases((AxisOperation)axisOperation);
                    axisOperation.addParameter(new Parameter("org.wso2.ws.dataservice.db_operation_element", (Object)operation));
                    axisService.addOperation((AxisOperation)axisOperation);
                    OMElement callQuery = operation.getFirstChildWithName(new QName("call-query"));
                    String hrefVal = callQuery.getAttributeValue(new QName("href"));
                    OMElement query = (OMElement)queryMap.get(hrefVal);
                    CallQuery callQueryElement = new CallQuery();
                    callQueryElement.populateCallQuery(query);
                    Parameter callQueryParameter = new Parameter();
                    callQueryParameter.setName("CallQuery");
                    callQueryParameter.setValue((Object)callQueryElement);
                    axisOperation.addParameter(callQueryParameter);
                }
                Object var25_28 = null;
            }
            catch (FileNotFoundException e) {
                throw new AxisFault("Error reading service configuration file.", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new AxisFault("Error while parsing the service configuration file.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var25_29 = null;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage());
            }
        }
        try {}
        catch (IOException e) {
            throw new AxisFault(e.getMessage());
        }
        fis.close();
        DataServiceDocLitWrappedSchemaGenerator schemaGenerator = new DataServiceDocLitWrappedSchemaGenerator(axisService, callQueryMap);
        schemaGenerator.setElementFormDefault("unqualified");
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)DBConstants.WSO2_NAMESPACE);
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        axisService.setElementFormDefault(false);
        schemaGenerator.generateSchema();
        return axisService;
    }

    private void extractParamsPerCallQuery(OMElement configElement, Iterator queries, HashMap paramsPerCallQueryMap) {
        Iterator operations = configElement.getChildrenWithName(new QName("operation"));
        while (operations.hasNext()) {
            OMElement operationElement = (OMElement)operations.next();
            Iterator callQueries = operationElement.getChildrenWithName(new QName("call-query"));
            if (callQueries == null) continue;
            Object obj = null;
            while (callQueries.hasNext() && !((obj = callQueries.next()) instanceof OMElement)) {
            }
            if (obj == null) continue;
            OMElement callQuery = obj;
            Iterator withParams = callQuery.getChildrenWithName(new QName("with-param"));
            HashMap<String, String> paramNameWithQueryParam = new HashMap<String, String>();
            while (withParams.hasNext()) {
                OMElement withParam = (OMElement)withParams.next();
                String paramName = withParam.getAttributeValue(new QName("name"));
                String queryParam = withParam.getAttributeValue(new QName("query-param"));
                paramNameWithQueryParam.put(paramName, queryParam);
            }
            String callQueryRef = callQuery.getAttributeValue(new QName("href"));
            paramsPerCallQueryMap.put(callQueryRef, paramNameWithQueryParam);
        }
    }

    public static String getJavaTypeFromSQLType(String sqlType) {
        HashMap convertionMap = DBDeployer.getConversionTable();
        return (String)convertionMap.get(sqlType);
    }

    private HashMap getProperties(OMElement confiObj) {
        HashMap<String, String> props = new HashMap<String, String>();
        Iterator iter = confiObj.getChildrenWithName(new QName("property"));
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            props.put(element.getAttributeValue(new QName("name")), element.getText());
        }
        return props;
    }

    private ArrayList processService(DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, ConfigurationContext configCtx) throws AxisFault {
        String dataServiceFileName = currentFile.getName();
        String serviceGroupName = dataServiceFileName.substring(0, dataServiceFileName.lastIndexOf("."));
        AxisService axisService = this.createDBService(currentFile.getAbsolutePath(), configCtx.getAxisConfiguration());
        axisServiceGroup.setServiceGroupName(serviceGroupName);
        axisService.setParent(axisServiceGroup);
        axisService.setClassLoader(this.axisConfig.getServiceClassLoader());
        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
        serviceList.add(axisService);
        return serviceList;
    }

    private DBMessageReceiver getDbMessageReceiver() {
        if (this.dbMessageReceiver == null) {
            this.dbMessageReceiver = new DBMessageReceiver();
        }
        return this.dbMessageReceiver;
    }
}

