/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.wso2.ws.dataservice.beans.CSVQuery;
import org.wso2.ws.dataservice.beans.ExcelQuery;

public class DBUtils {
    private static final Log log = LogFactory.getLog((Class)DBUtils.class);
    private String configFilePath;

    public static OMNode toOM(Reader reader) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((Reader)reader);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        return staxOMBuilder.getDocumentElement();
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String config_file_parth) {
        this.configFilePath = config_file_parth;
    }

    private static synchronized OMElement processSQLQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        Iterator iter = inputMessage.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            inputs.put(element.getLocalName(), element.getText());
        }
        OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
        return DBUtils.getRDBMSResult(callQueryElement, axisService, inputs);
    }

    private static OMElement getRDBMSResult(OMElement callQueryElement, AxisService axisService, HashMap inputs) {
        OMElement resultElement;
        block5: {
            resultElement = null;
            try {
                OMElement queryElement;
                String href = callQueryElement.getAttributeValue(new QName("href"));
                if (href != null) {
                    HashMap queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                    queryElement = (OMElement)queries.get(href);
                } else {
                    queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
                }
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<Integer, String> paramOrder = new HashMap<Integer, String>();
                Iterator iParams = queryElement.getChildrenWithName(new QName("param"));
                int position = 0;
                while (iParams.hasNext()) {
                    OMElement param = (OMElement)iParams.next();
                    String paramName = param.getAttributeValue(new QName("name"));
                    String sqlType = param.getAttributeValue(new QName("sqlType"));
                    params.put(paramName, sqlType);
                    paramOrder.put(new Integer(position + 1), paramName);
                    ++position;
                }
                String query = queryElement.getFirstChildWithName(new QName("sql")).getText();
                String firstPartOfSQL = query.substring(0, 6);
                resultElement = firstPartOfSQL.equalsIgnoreCase("SELECT") ? DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, axisService, false) : (firstPartOfSQL.equalsIgnoreCase("INSERT") || firstPartOfSQL.equalsIgnoreCase("UPDATE") || firstPartOfSQL.equalsIgnoreCase("DELETE") || firstPartOfSQL.equalsIgnoreCase("CREATE") ? DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, axisService, true) : DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, axisService, false));
            }
            catch (Exception e) {
                if (!(e instanceof AxisFault)) break block5;
                return DBUtils.generateErrorResponse(axisService.getTargetNamespace(), (AxisFault)((Object)e));
            }
        }
        return resultElement;
    }

    private static OMElement generateErrorResponse(String targetNamespace, AxisFault e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(targetNamespace, "data");
        OMElement resultElement = fac.createOMElement("data", omNs);
        OMElement faultElement = fac.createOMElement("fault", null);
        OMElement codeElement = fac.createOMElement("code", omNs);
        codeElement.setText(e.getMessage());
        OMElement detailElement = fac.createOMElement("detail", omNs);
        detailElement.setText(sw.toString());
        faultElement.addChild((OMNode)codeElement);
        faultElement.addChild((OMNode)detailElement);
        resultElement.addChild((OMNode)faultElement);
        return resultElement;
    }

    private static OMElement getSelectResult(OMElement queryElement, HashMap inputValues, HashMap params, HashMap paramOrder, AxisService axisService, boolean isDML) throws AxisFault {
        OMElement resultElement = null;
        Connection conn = null;
        String sqlQuery = queryElement.getFirstChildWithName(new QName("sql")).getText();
        try {
            Parameter dbConnectionParam = axisService.getParameter("org.wso2.ws.dataservice.dbconnection");
            if (dbConnectionParam == null) {
                throw new AxisFault("Database connection not found in Axis Configuration");
            }
            conn = (Connection)dbConnectionParam.getValue();
            conn.setAutoCommit(false);
            PreparedStatement preparedStatement = DBUtils.getProcessedPreparedStatement(inputValues, params, paramOrder, conn, sqlQuery);
            int responseCode = -1;
            ResultSet rs = null;
            if (isDML) {
                responseCode = preparedStatement.executeUpdate();
            } else {
                rs = preparedStatement.executeQuery();
            }
            OMElement result = queryElement.getFirstChildWithName(new QName("result"));
            String wrapperElementName = result.getAttributeValue(new QName("element"));
            String rowElementName = result.getAttributeValue(new QName("rowName"));
            if (wrapperElementName == null || wrapperElementName.trim().length() == 0) {
                wrapperElementName = "results";
            }
            if (rowElementName == null || rowElementName.trim().length() == 0) {
                rowElementName = "row";
            }
            String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
            resultElement = fac.createOMElement(wrapperElementName, omNs);
            if (isDML) {
                resultElement.setText("Your query executed successfully. Return code from the database was " + responseCode);
            } else {
                if (!axisService.isElementFormDefault()) {
                    omNs = fac.createOMNamespace("", "data");
                }
                while (rs.next()) {
                    HashMap<String, String> elementValues = new HashMap<String, String>();
                    int columnCount = rs.getMetaData().getColumnCount();
                    OMElement row = fac.createOMElement(rowElementName, omNs);
                    if (rowElementName == null) {
                        row = resultElement;
                    }
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = rs.getMetaData().getColumnLabel(i);
                        String columnValue = rs.getString(columnName);
                        elementValues.put(columnName, columnValue);
                    }
                    Iterator elements = result.getChildElements();
                    boolean useAsParamToNextQuery = false;
                    while (elements.hasNext()) {
                        OMElement element = (OMElement)elements.next();
                        if (element.getLocalName().equals("element")) {
                            String elementValue;
                            String displayTagName = element.getAttributeValue(new QName("name"));
                            String resultSetFieldName = element.getAttributeValue(new QName("column"));
                            if (resultSetFieldName == null) {
                                resultSetFieldName = element.getAttributeValue(new QName("param"));
                                useAsParamToNextQuery = true;
                            }
                            if (useAsParamToNextQuery) {
                                elementValue = (String)params.get(resultSetFieldName);
                                elementValues.put(resultSetFieldName, elementValue);
                            } else {
                                elementValue = (String)elementValues.get(resultSetFieldName);
                            }
                            if (columnDefalut == null || columnDefalut.equals("element")) {
                                OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                                rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                                row.addChild((OMNode)rowElement);
                                continue;
                            }
                            if (!columnDefalut.equals("attribute")) continue;
                            row.addAttribute(displayTagName, elementValue, omNs);
                            continue;
                        }
                        if (!element.getLocalName().equals("call-query")) continue;
                        OMElement rowElement = DBUtils.getRDBMSResult(element, axisService, elementValues);
                        row.addChild((OMNode)rowElement);
                    }
                    if (rowElementName == null) continue;
                    resultElement.addChild((OMNode)row);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Exception occurred while trying to execute the SQL statement : " + sqlQuery), (Throwable)e);
            throw new AxisFault("Exception occurred while trying to execute the SQL statement : " + sqlQuery, (Throwable)e);
        }
        return resultElement;
    }

    public static OMElement invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation axisOp = msgContext.getAxisOperation();
        AxisService axisService = msgContext.getAxisService();
        OMElement inputMessage = msgContext.getEnvelope().getBody().getFirstElement();
        OMElement operationElement = (OMElement)axisOp.getParameterValue("org.wso2.ws.dataservice.db_operation_element");
        if ("CSV".equals((String)axisService.getParameterValue("DATASOURCE_TYPE"))) {
            return DBUtils.processCSVQuery(operationElement, axisService, inputMessage);
        }
        if ("EXCEL".equals((String)axisService.getParameterValue("DATASOURCE_TYPE"))) {
            return DBUtils.processExcelQuery(operationElement, axisService, inputMessage);
        }
        return DBUtils.processSQLQuery(operationElement, axisService, inputMessage);
    }

    private static boolean checkLibraryAvailability(String libraryName) throws AxisFault {
        try {
            if ("POI".equals(libraryName)) {
                Class.forName("org.apache.poi.poifs.filesystem.POIFSFileSystem");
            } else if ("OpenCSV".equals(libraryName)) {
                Class.forName("au.com.bytecode.opencsv.CSVReader");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Library not found for : " + libraryName), (Throwable)e);
            throw new AxisFault("Library not found for : " + libraryName, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized OMElement processExcelQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) throws AxisFault {
        OMElement oMElement;
        String excelFilePath = (String)axisService.getParameterValue("excel_datasource");
        log.info((Object)("Using Excel file from : " + excelFilePath));
        InputStream dataSourceInputStream = null;
        try {
            try {
                OMElement queryElement;
                DBUtils.checkLibraryAvailability("POI");
                if (excelFilePath.startsWith("http://")) {
                    URL url = new URL(excelFilePath);
                    dataSourceInputStream = url.openStream();
                } else {
                    dataSourceInputStream = new FileInputStream(excelFilePath);
                }
                POIFSFileSystem fs = new POIFSFileSystem(dataSourceInputStream);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
                String href = callQueryElement.getAttributeValue(new QName("href"));
                if (href != null) {
                    HashMap queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                    queryElement = (OMElement)queries.get(href);
                } else {
                    queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
                }
                oMElement = DBUtils.getExcelResult(wb, queryElement, axisService);
                Object var12_13 = null;
                if (dataSourceInputStream == null) return oMElement;
            }
            catch (FileNotFoundException e1) {
                log.error((Object)("Excel file not fould : " + excelFilePath), (Throwable)e1);
                throw new AxisFault("Excel file not fould : " + excelFilePath);
            }
            catch (IOException e) {
                log.error((Object)("Error loading Excel file : " + excelFilePath), (Throwable)e);
                throw new AxisFault("Error loading Excel file : " + excelFilePath);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (dataSourceInputStream == null) throw throwable;
            try {
                dataSourceInputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                log.debug((Object)("Error occured while close InputStream for : " + excelFilePath), (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            log.debug((Object)("Error occured while close InputStream for : " + excelFilePath), (Throwable)e);
            return oMElement;
        }
        dataSourceInputStream.close();
        return oMElement;
    }

    /*
     * WARNING - void declaration
     */
    private static OMElement getExcelResult(HSSFWorkbook wb, OMElement queryElement, AxisService axisService) throws AxisFault {
        OMElement resultElement = null;
        ExcelQuery excelQuery = new ExcelQuery(axisService, queryElement);
        OMElement result = queryElement.getFirstChildWithName(new QName("result"));
        String wrapperElementName = result.getAttributeValue(new QName("element"));
        String rowElementName = result.getAttributeValue(new QName("rowName"));
        String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
        resultElement = fac.createOMElement(wrapperElementName, omNs);
        if (!axisService.isElementFormDefault()) {
            omNs = fac.createOMNamespace("", "data");
        }
        String sheetName = excelQuery.getWorkBookName();
        int startReadingFromRow = excelQuery.getStartingRow();
        if (startReadingFromRow >= 0) {
            --startReadingFromRow;
        }
        int maxRowCount = excelQuery.getMaxRowCount();
        HSSFSheet sheet = wb.getSheet(sheetName);
        int rowCount = sheet.getPhysicalNumberOfRows();
        HSSFRow firstRow = null;
        if (excelQuery.hasHeaders()) {
            firstRow = sheet.getRow(0);
        }
        int processedRowCount = 0;
        for (int r = 0; r < rowCount; ++r) {
            if (r < startReadingFromRow) continue;
            if (processedRowCount == maxRowCount) break;
            HSSFRow hssfRow = sheet.getRow(r);
            OMElement row = fac.createOMElement(rowElementName, omNs);
            if (rowElementName == null) {
                row = resultElement;
            }
            Iterator elements = result.getChildElements();
            while (elements.hasNext()) {
                void var26_26;
                short columnNumber;
                OMElement element = (OMElement)elements.next();
                if (!element.getLocalName().equals("element")) continue;
                String displayTagName = element.getAttributeValue(new QName("name"));
                String columnValue = element.getAttributeValue(new QName("column"));
                short a = 1;
                if (excelQuery.hasHeaders()) {
                    columnNumber = DBUtils.getExcelColumnNumber(columnValue, firstRow);
                } else {
                    try {
                        columnNumber = (short)(Short.valueOf(columnValue) - a);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Column value for element : " + displayTagName + " should be a number."), (Throwable)e);
                        throw new AxisFault("Column value for element : " + displayTagName + " should be a number.");
                    }
                }
                HSSFCell hssfCell = hssfRow.getCell((short)var26_26);
                String elementValue = "";
                if (hssfCell != null) {
                    if (1 == hssfCell.getCellType()) {
                        elementValue = hssfCell.getRichStringCellValue().getString();
                    } else if (3 != hssfCell.getCellType()) {
                        if (4 == hssfCell.getCellType()) {
                            elementValue = String.valueOf(hssfCell.getBooleanCellValue());
                        } else if (2 == hssfCell.getCellType()) {
                            elementValue = "{formula}";
                        } else if (0 == hssfCell.getCellType()) {
                            elementValue = String.valueOf(hssfCell.getNumericCellValue());
                        }
                    }
                }
                if (columnDefalut == null || columnDefalut.equals("element")) {
                    OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                    rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                    row.addChild((OMNode)rowElement);
                    continue;
                }
                if (!columnDefalut.equals("attribute")) continue;
                row.addAttribute(displayTagName, elementValue, omNs);
            }
            if (rowElementName == null) continue;
            resultElement.addChild((OMNode)row);
            ++processedRowCount;
        }
        return resultElement;
    }

    private static short getExcelColumnNumber(String columnName, HSSFRow headerRow) throws AxisFault {
        int noOfCells = headerRow.getPhysicalNumberOfCells();
        short columnNo = -1;
        for (int a = 0; a < noOfCells; ++a) {
            HSSFCell cell = headerRow.getCell((short)a);
            if (1 == cell.getCellType()) {
                if (!columnName.equals(cell.getRichStringCellValue().getString())) continue;
                columnNo = (short)a;
                break;
            }
            if (0 != cell.getCellType()) continue;
            try {
                double columnNameInDouble = Double.valueOf(columnName);
                if (columnNameInDouble != cell.getNumericCellValue()) continue;
                columnNo = (short)a;
                break;
            }
            catch (NumberFormatException e) {
                log.error((Object)("Numeric value expected for Column Name : " + columnName), (Throwable)e);
                throw new AxisFault("Numeric value expected for Column Name : " + columnName, (Throwable)e);
            }
        }
        return columnNo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized OMElement processCSVQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) throws AxisFault {
        HashMap queries;
        String csvFilePath = (String)axisService.getParameterValue("csv_datasource");
        log.info((Object)("Using CSV file from : " + csvFilePath));
        CSVReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                OMElement queryElement;
                if (csvFilePath.startsWith("http://")) {
                    URL url = new URL(csvFilePath);
                    inputStreamReader = new InputStreamReader(url.openStream());
                    reader = new CSVReader((Reader)inputStreamReader);
                } else {
                    if (csvFilePath.startsWith("." + File.separator) || csvFilePath.startsWith(".." + File.separator)) {
                        File csvFile = new File(csvFilePath);
                        csvFilePath = csvFile.getAbsolutePath();
                        log.info((Object)("relative file path reference found. Using " + csvFilePath + " as absolute path."));
                    }
                    reader = new CSVReader((Reader)new FileReader(csvFilePath));
                }
                OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
                String href = callQueryElement.getAttributeValue(new QName("href"));
                if (href != null) {
                    queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                    queryElement = (OMElement)queries.get(href);
                } else {
                    queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
                }
                queries = DBUtils.getCSVResult(reader, queryElement, axisService);
                Object var11_14 = null;
                if (inputStreamReader == null) return queries;
            }
            catch (FileNotFoundException e2) {
                log.error((Object)("CSV file not found : " + csvFilePath), (Throwable)e2);
                throw new AxisFault("CSV file not found : " + csvFilePath, (Throwable)e2);
            }
            catch (MalformedURLException e3) {
                log.error((Object)("Incorrect URL : " + csvFilePath), (Throwable)e3);
                throw new AxisFault("Incorrect URL : " + csvFilePath, (Throwable)e3);
            }
            catch (IOException e4) {
                log.error((Object)("Error opening stream for : " + csvFilePath), (Throwable)e4);
                throw new AxisFault("Error opening stream for : " + csvFilePath, (Throwable)e4);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException e5) {
                e5.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException e5) {
            e5.printStackTrace();
            return queries;
        }
        inputStreamReader.close();
        return queries;
    }

    private static OMElement getCSVResult(CSVReader reader, OMElement queryElement, AxisService axisService) throws AxisFault {
        String[] nextLine;
        OMElement resultElement = null;
        CSVQuery csvQuery = new CSVQuery(axisService);
        int start = csvQuery.getStartingRow();
        int end = csvQuery.getMaxRowCount();
        int noOfRowsToRead = 0;
        noOfRowsToRead = end == -1 ? -1 : end;
        if (start >= 0) {
            --start;
        }
        OMElement result = queryElement.getFirstChildWithName(new QName("result"));
        String wrapperElementName = result.getAttributeValue(new QName("element"));
        String rowElementName = result.getAttributeValue(new QName("rowName"));
        String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
        resultElement = fac.createOMElement(wrapperElementName, omNs);
        if (!axisService.isElementFormDefault()) {
            omNs = fac.createOMNamespace("", "data");
        }
        int[] columnNumbersToRead = null;
        if (csvQuery.hasHeaders()) {
            try {
                nextLine = reader.readNext();
                columnNumbersToRead = new int[csvQuery.getColumnNames().length];
                int index = 0;
                for (int b = 0; b < nextLine.length; ++b) {
                    String realColumnName = nextLine[b];
                    if (!csvQuery.isColumnNameMentioned(realColumnName)) continue;
                    columnNumbersToRead[index] = b;
                    ++index;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error reading header record", (Throwable)e);
                throw new AxisFault("Error reading header record", (Throwable)e);
            }
        } else {
            columnNumbersToRead = new int[csvQuery.getColumnNames().length];
            String colNo = "";
            for (int a = 0; a < csvQuery.getColumnNames().length; ++a) {
                try {
                    colNo = csvQuery.getColumnNames()[a];
                    columnNumbersToRead[a] = Integer.valueOf(colNo);
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("When headers are set to false, you need to have numeric value for column.Incorrect value found : " + colNo), (Throwable)e);
                    throw new AxisFault("When headers are set to false, you need to have numeric value for column.Incorrect value found : " + colNo, (Throwable)e);
                }
            }
        }
        try {
            int processedRowCount = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (nextLine.length == 1 && (nextLine[0] == null || nextLine[0].trim().equals(""))) continue;
                if (noOfRowsToRead != -1 && processedRowCount + start == noOfRowsToRead + start) break;
                if (start > processedRowCount + 1) {
                    ++processedRowCount;
                    continue;
                }
                HashMap<Integer, String> elementValues = new HashMap<Integer, String>();
                int columnCount = csvQuery.getColumnNames().length;
                OMElement row = fac.createOMElement(rowElementName, omNs);
                if (rowElementName == null) {
                    row = resultElement;
                }
                for (int i = 0; i < columnCount; ++i) {
                    int columnNo = columnNumbersToRead[i];
                    String columnValue = "";
                    try {
                        columnValue = nextLine[columnNo];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        log.info((Object)("Reading row : " + (processedRowCount + 1) + ".No value found " + "for column no : " + columnNo + ".Empty value will be printed."), (Throwable)e);
                    }
                    elementValues.put(new Integer(columnNo), columnValue);
                }
                Iterator elements = result.getChildElements();
                while (elements.hasNext()) {
                    OMElement element = (OMElement)elements.next();
                    if (!element.getLocalName().equals("element")) continue;
                    String displayTagName = element.getAttributeValue(new QName("name"));
                    String columnReference = element.getAttributeValue(new QName("column"));
                    int columnRef = 0;
                    try {
                        columnRef = Integer.valueOf(columnReference);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Column value specified " + columnReference + " for " + displayTagName + " should be a numeric value."), (Throwable)e);
                        throw new AxisFault("Column value specified " + columnReference + " for " + displayTagName + " should be a numeric value.", (Throwable)e);
                    }
                    String elementValue = (String)elementValues.get(new Integer(columnRef - 1));
                    if (columnDefalut == null || columnDefalut.equals("element")) {
                        OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                        rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                        row.addChild((OMNode)rowElement);
                        continue;
                    }
                    if (!columnDefalut.equals("attribute")) continue;
                    row.addAttribute(displayTagName, elementValue, omNs);
                }
                if (rowElementName != null) {
                    resultElement.addChild((OMNode)row);
                }
                ++processedRowCount;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading CSV file.", (Throwable)e);
            throw new AxisFault("Error reading CSV file.", (Throwable)e);
        }
        return resultElement;
    }

    public static Connection createConnection(AxisService axisService) throws AxisFault {
        try {
            log.info((Object)("Creating database connection for " + axisService.getName()));
            Class.forName((String)axisService.getParameterValue("org.wso2.ws.dataservice.driver")).newInstance();
            Properties props = new Properties();
            props.put("user", axisService.getParameterValue("org.wso2.ws.dataservice.user"));
            props.put("password", axisService.getParameterValue("org.wso2.ws.dataservice.password"));
            Connection conn = DriverManager.getConnection((String)axisService.getParameterValue("org.wso2.ws.dataservice.protocol"), props);
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)"Error occured while connecting to database", (Throwable)e);
            throw new AxisFault("Error occured while connecting to database", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("JDBC driver not available in classpath : " + e.getMessage()));
            throw new AxisFault("JDBC driver not available in classpath : " + e.getMessage());
        }
        catch (InstantiationException e) {
            log.error((Object)("Error occurred during instantiating " + (String)axisService.getParameterValue("org.wso2.ws.dataservice.driver")), (Throwable)e);
            throw new AxisFault("Error occurred during instantiating " + (String)axisService.getParameterValue("org.wso2.ws.dataservice.driver"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal Access error during loading " + (String)axisService.getParameterValue("org.wso2.ws.dataservice.driver")), (Throwable)e);
            throw new AxisFault("Illegal Access error during loading " + (String)axisService.getParameterValue("org.wso2.ws.dataservice.driver"), (Throwable)e);
        }
    }

    public static PreparedStatement getProcessedPreparedStatement(HashMap inputs, HashMap params, HashMap paramOrder, Connection conn, String sqlStatement) throws AxisFault {
        String paramName = null;
        String sqlType = null;
        String value = null;
        try {
            PreparedStatement sqlQuery = conn.prepareStatement(sqlStatement);
            Set paramNames = params.keySet();
            Object[] pramNameArray = paramNames.toArray();
            for (int i = 0; i < pramNameArray.length; ++i) {
                paramName = (String)paramOrder.get(new Integer(i + 1));
                sqlType = (String)params.get(paramName);
                value = (String)inputs.get(paramName);
                if (sqlType == null) {
                    sqlQuery.setString(i + 1, value);
                    continue;
                }
                if (sqlType.equals("INTEGER")) {
                    sqlQuery.setInt(i + 1, Integer.parseInt(value));
                    continue;
                }
                if (sqlType.equals("STRING")) {
                    if (value == null || value.trim().length() == 0) {
                        log.error((Object)("Empty value found for parameter : " + paramName));
                        throw new AxisFault("Empty value found for parameter : " + paramName);
                    }
                    sqlQuery.setString(i + 1, value);
                    continue;
                }
                if (sqlType.equals("DOUBLE")) {
                    sqlQuery.setDouble(i + 1, Double.parseDouble(value));
                    continue;
                }
                if (!sqlType.equals("DATE")) continue;
                try {
                    sqlQuery.setDate(i + 1, Date.valueOf(value));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Incorrect date format for parameter : " + paramName), (Throwable)e);
                    throw new AxisFault("Incorrect date format for parameter  : " + paramName + ".Date should be in yyyy-mm-dd format.", (Throwable)e);
                }
            }
            return sqlQuery;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Incorrect value found for parameter : " + paramName), (Throwable)e);
            throw new AxisFault("Incorrect value found for parameter : " + paramName, (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)("Error occurred while preparing prepared statement for sql : " + sqlStatement), (Throwable)e);
            throw new AxisFault("Error occurred while preparing prepared statement for sql : " + sqlStatement, (Throwable)e);
        }
    }
}

