/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.actionexecutor.ServerProcess;

public class OpenFileFinder
implements ActionExecutor {
    private static Logger log = LogManager.getLogger(OpenFileFinder.class);
    private String processId = ServerProcess.getProcessId();

    @Override
    public void execute(String filepath) {
        if (new File(filepath).exists()) {
            String frame = filepath + "/lsof-output.txt ";
            String command = "lsof -p " + this.processId;
            try {
                Process process = Runtime.getRuntime().exec(command);
                Scanner scanner = new Scanner(process.getInputStream(), "IBM850");
                scanner.useDelimiter("\\A");
                try {
                    FileWriter writer = new FileWriter(frame);
                    writer.write(scanner.next());
                    writer.close();
                }
                catch (IOException e) {
                    log.error("Unable to do write in file for OpenFileFinder executor");
                }
                scanner.close();
                log.info("OpenFileFinder executed successfully.");
            }
            catch (IOException e) {
                log.error("Unable to do lsof command", (Throwable)e);
            }
        }
    }
}

