/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.utils.ConfigMapHolder;

public class ServerProcess {
    private static final Logger log = LogManager.getLogger(ServerProcess.class);
    private static String nodeID;
    static String processId;
    static String processFilePath;

    public static String getProcessId() {
        if (processId == null) {
            ServerProcess.setProcessId(processFilePath);
        }
        return processId;
    }

    public static void setProcessId(String path) {
        processFilePath = path;
        Object appHome = System.getProperty("app.home");
        if (!((String)appHome).endsWith(File.separator)) {
            appHome = (String)appHome + File.separator;
        }
        try (RandomAccessFile file = new RandomAccessFile((String)appHome + path, "r");){
            processId = file.readLine();
            log.info("Server Process ID: " + processId);
        }
        catch (IOException e) {
            log.error("wso2carbon.pid file not found.");
        }
    }

    public static String getNodeId() {
        if (nodeID == null) {
            String nodeId = System.getProperty("node.id");
            if (StringUtils.isEmpty((CharSequence)nodeId)) {
                Object id = ConfigMapHolder.getInstance().getConfigMap().get("server_configuration.node_id");
                nodeId = null != id ? id.toString() : processId;
            }
            nodeID = nodeId;
        }
        return nodeID;
    }

    public static void writePID(String runtimePath) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int indexOfAt = jvmName.indexOf(64);
        if (indexOfAt < 1) {
            log.warn("Cannot extract current process ID from JVM name '" + jvmName + "'.");
            return;
        }
        String pid = jvmName.substring(0, indexOfAt);
        Path runtimePidFile = Paths.get(runtimePath, "diagnostics.pid");
        try {
            Files.write(runtimePidFile, pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.warn("Cannot write process ID '" + pid + "' to '" + runtimePidFile.toString() + "' file.", (Throwable)e);
        }
    }
}

