/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.postexecutor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.utils.ConfigMapHolder;

public class FTPUploader {
    private static final Logger log = LogManager.getLogger(FTPUploader.class);

    public void uploadFile(String zipFilePath, String zipFileName) {
        String ftpServer = "";
        int ftpPort = 0;
        Object ftpDir = "";
        try {
            Map<String, Object> configMap = ConfigMapHolder.getInstance().getConfigMap();
            ftpServer = (String)configMap.get("ftp_uploader.host");
            String ftpUser = (String)configMap.get("ftp_uploader.username");
            String ftpPassword = (String)configMap.get("ftp_uploader.password");
            ftpPort = Integer.parseInt((String)configMap.get("ftp_uploader.port"));
            ftpDir = (String)configMap.get("ftp_uploader.directory");
            FTPClient ftpClient = new FTPClient();
            ftpClient.connect(ftpServer, ftpPort);
            ftpClient.login(ftpUser, ftpPassword);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setRemoteVerificationEnabled(false);
            File zipFile = new File(zipFilePath + zipFileName);
            if (!((String)ftpDir).endsWith("/")) {
                ftpDir = (String)ftpDir + File.separator;
            }
            String remoteFile = (String)ftpDir + zipFileName;
            FileInputStream inputStream = new FileInputStream(zipFile);
            boolean done = ftpClient.storeFile(remoteFile, (InputStream)inputStream);
            ((InputStream)inputStream).close();
            if (done) {
                log.info("Zip file " + zipFileName + " is uploaded successfully to the FTP server at " + ftpServer);
            }
            ftpClient.logout();
            ftpClient.disconnect();
        }
        catch (Exception e) {
            log.error("Error occurred while uploading the zip file to the FTP server at " + ftpServer + ", port " + ftpPort + ", directory " + (String)ftpDir, (Throwable)e);
        }
    }
}

