/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.postexecutor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.postexecutor.ZipFileExecutor;

public class PostExecutorTask
extends TimerTask {
    private static final Logger log = LogManager.getLogger(PostExecutorTask.class);
    private final String logLine;
    private final String folderPath;

    public PostExecutorTask(String logLine, String folderPath) {
        this.logLine = logLine;
        this.folderPath = folderPath;
    }

    @Override
    public void run() {
        this.writeLogLine(this.logLine);
        this.executeZipFileExecutor();
        this.deleteFolder();
    }

    private void writeLogLine(String logLine) {
        try {
            FileWriter writer = new FileWriter(this.folderPath + "/log.txt");
            writer.write(logLine);
            writer.close();
        }
        catch (IOException e) {
            log.error("Error occurred while writing the log line to the file", (Throwable)e);
        }
    }

    private void executeZipFileExecutor() {
        ZipFileExecutor zipFileExecutor = new ZipFileExecutor();
        zipFileExecutor.execute(this.folderPath);
    }

    private void deleteFolder() {
        File dumpFolder = new File(this.folderPath);
        if (dumpFolder.exists()) {
            String[] entries;
            for (String entry : entries = dumpFolder.list()) {
                File currentFile = new File(dumpFolder.getPath(), entry);
                currentFile.delete();
            }
            dumpFolder.delete();
        }
    }
}

