/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.postexecutor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ServerProcess;
import org.wso2.diagnostics.postexecutor.FTPUploader;
import org.wso2.diagnostics.postexecutor.SFTPUploader;
import org.wso2.diagnostics.utils.CommonUtils;
import org.wso2.diagnostics.utils.ConfigMapHolder;
import org.wso2.diagnostics.utils.FileUtils;

public class ZipFileExecutor {
    private final Logger log = LogManager.getLogger(ZipFileExecutor.class);
    private final String logDirPath;
    private final int maxFiles;

    public ZipFileExecutor() {
        String logDirRelativePath = ConfigMapHolder.getInstance().getConfigMap().get("zip_file_configuration.output_directory").toString();
        this.logDirPath = System.getProperty("app.home") + File.separator + logDirRelativePath + File.separator;
        this.maxFiles = Integer.parseInt(ConfigMapHolder.getInstance().getConfigMap().get("zip_file_configuration.max_count").toString());
        File logFolder = new File(this.logDirPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
    }

    public void execute(String path) {
        this.log.info("Zipping the folder at " + path);
        File folder = new File(path);
        try {
            String zipFileName = ServerProcess.getNodeId() + "_" + folder.getName() + ".zip";
            this.zipFolder(path, this.logDirPath + zipFileName);
            this.log.info("Diagnosis Dumped in :" + this.logDirPath + zipFileName);
            FileUtils.rotateFiles(new File(this.logDirPath), this.maxFiles);
            this.executeUploader(this.logDirPath, zipFileName);
        }
        catch (Exception e) {
            this.log.error("Unable to zip the file at " + path, (Throwable)e);
        }
    }

    private void zipFolder(String srcFolder, String destZipFile) {
        try {
            FileOutputStream fileWriter = new FileOutputStream(destZipFile);
            ZipOutputStream zip = new ZipOutputStream(fileWriter);
            this.addFolderToZip("", srcFolder, zip);
            zip.flush();
            zip.close();
        }
        catch (Exception e) {
            this.log.error("Error occurred while zipping the folder", (Throwable)e);
        }
    }

    private void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                this.addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip);
                continue;
            }
            this.addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip);
        }
    }

    private void executeUploader(String logDirpath, String zipName) {
        boolean sftpUploadEnabled;
        boolean ftpUploadEnabled = CommonUtils.getBooleanValue(ConfigMapHolder.getInstance().getConfigMap().get("ftp_uploader.enabled"), false);
        if (ftpUploadEnabled) {
            FTPUploader ftpUploader = new FTPUploader();
            ftpUploader.uploadFile(logDirpath, zipName);
        }
        if (sftpUploadEnabled = CommonUtils.getBooleanValue(ConfigMapHolder.getInstance().getConfigMap().get("sftp_uploader.enabled"), false)) {
            SFTPUploader sftpUploader = new SFTPUploader();
            sftpUploader.uploadFile(logDirpath, zipName);
        }
    }
}

