/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger log = LogManager.getLogger(FileUtils.class);

    public static void writeToFile(String filePath, String content) {
        try {
            Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Error while creating file", (Throwable)e);
        }
        try {
            Files.write(Paths.get(filePath, new String[0]), content.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            log.error("Error while writing to file", (Throwable)e);
        }
    }

    public static void copyFile(String source, String destination) {
        try {
            Files.copy(Paths.get(source, new String[0]), Paths.get(destination, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) {
        try {
            FileOutputStream fileWriter = new FileOutputStream(destZipFile);
            ZipOutputStream zip = new ZipOutputStream(fileWriter);
            FileUtils.addFolderToZip("", srcFolder, zip);
            zip.flush();
            zip.close();
        }
        catch (Exception e) {
            log.error("Error while zipping the folder", (Throwable)e);
        }
    }

    public static String createTimeStampFolder() {
        String folderName;
        File dumpFolder;
        String folderPath = System.getProperty("app.home") + "/temp/";
        File logFolder = new File(folderPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
        if (!(dumpFolder = new File(folderPath + (folderName = new Timestamp(System.currentTimeMillis()).toString().replace(" ", "_")))).exists()) {
            try {
                if (dumpFolder.mkdir()) {
                    folderPath = folderPath + folderName;
                }
            }
            catch (SecurityException se) {
                log.error("Error while creating folder for dump", (Throwable)se);
            }
        }
        return folderPath;
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileUtils.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                FileUtils.addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip);
                continue;
            }
            FileUtils.addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip);
        }
    }

    public static void deleteFolder(String folderPath) {
        File dumpFolder = new File(folderPath);
        if (dumpFolder.exists()) {
            String[] entries = dumpFolder.list();
            if (entries == null) {
                return;
            }
            for (String entry : entries) {
                File currentFile = new File(dumpFolder.getPath(), entry);
                currentFile.delete();
            }
            dumpFolder.delete();
        }
    }

    public static void rotateFiles(File directory, int maxFiles) {
        File[] files = directory.listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        int fileCount = files.length;
        if (fileCount >= maxFiles) {
            for (int i = 0; i < fileCount - maxFiles + 1; ++i) {
                files[i].delete();
            }
        }
    }
}

